/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.tasks.MovieRemoveDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;

class MovieSourcePanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private JList<String> listDataSources;

    public MovieSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][200lp,grow]"));
        JLabel lblMovieDataSources = new JLabel(TmmResourceBundle.getString("wizard.movie.datasources"));
        TmmFontHelper.changeFont(lblMovieDataSources, 1.3333, 1);
        this.add((Component)lblMovieDataSources, "cell 0 0");
        JPanel panelMovieDataSources = new JPanel();
        this.add((Component)panelMovieDataSources, "cell 0 1,grow");
        panelMovieDataSources.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[][200lp,grow]"));
        ReadOnlyTextArea tpDatasourceHint = new ReadOnlyTextArea(TmmResourceBundle.getString("wizard.datasource.hint"));
        panelMovieDataSources.add((Component)tpDatasourceHint, "cell 0 0 2 1,grow");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelMovieDataSources.add((Component)scrollPaneDataSources, "cell 0 1,grow");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        SquareIconButton btnAdd = new SquareIconButton(IconManager.ADD_INV);
        panelMovieDataSources.add((Component)btnAdd, "flowy,cell 1 1,aligny top");
        btnAdd.setToolTipText(TmmResourceBundle.getString("Button.add"));
        btnAdd.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.datasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                MovieModuleManager.getInstance().getSettings().addMovieDataSources(file.toAbsolutePath().toString());
            }
        });
        SquareIconButton btnRemove = new SquareIconButton(IconManager.REMOVE_INV);
        panelMovieDataSources.add((Component)btnRemove, "cell 1 1");
        btnRemove.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        btnRemove.addActionListener(arg0 -> {
            int row = this.listDataSources.getSelectedIndex();
            if (row != -1) {
                String path = MovieModuleManager.getInstance().getSettings().getMovieDataSource().get(row);
                Object[] choices = new String[]{TmmResourceBundle.getString("Button.continue"), TmmResourceBundle.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(this, String.format(TmmResourceBundle.getString("Settings.movie.datasource.remove.info"), path), TmmResourceBundle.getString("Settings.datasource.remove"), 0, -1, null, choices, TmmResourceBundle.getString("Button.abort"));
                if (decision == 0) {
                    if (TmmTaskManager.getInstance().isMainTaskRunning()) {
                        JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("Settings.datasource.remove.hint"));
                    }
                    TmmTaskManager.getInstance().addMainTask(new MovieRemoveDatasourceTask(path));
                }
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"movieDataSource");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listDataSources);
        jListBinding_1.bind();
    }
}

