/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater.getdown;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.updater.getdown.TmmGetdownResource;

public class TmmGetdownApplication
extends Application {
    public static final String UPDATE_FOLDER = "update/";

    public TmmGetdownApplication(EnvConfig envc) {
        super(envc);
    }

    protected Resource createResource(String path, EnumSet<Resource.Attr> attrs) throws MalformedURLException {
        return new TmmGetdownResource(path, this.getRemoteURL(path), this.getLocalPath(path), attrs);
    }

    protected File downloadFile(String path) throws IOException {
        File target = this.getLocalPath(path + "_new");
        URL targetURL = null;
        try {
            targetURL = this.getRemoteURL(path);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Requested to download invalid control file", new Object[]{"appbase", this._vappbase, "path", path, "error", e});
            throw new IOException("Invalid path '" + path + "'.", e);
        }
        Log.log.info((Object)("Attempting to refetch '" + path + "' from '" + targetURL + "'."), new Object[0]);
        Url url = new Url(targetURL.toString());
        url.download(target);
        return target;
    }
}

