/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater.getdown;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.tinymediamanager.core.Utils;

public class TmmGetdownResource
extends Resource {
    public TmmGetdownResource(String path, URL remote, File local, EnumSet<Resource.Attr> attrs) {
        super(path, remote, local, attrs);
        this._localNew = new File("update/" + File.separator + path);
        this._marker = new File("update/" + File.separator + ".getdown", path + "v");
        boolean unpack = attrs.contains(Resource.Attr.UNPACK);
        if (unpack && this._isZip) {
            this._unpacked = this._localNew.getParentFile();
        }
    }

    public String computeDigest(int version, MessageDigest md, ProgressObserver obs) throws IOException {
        File file = new File(this._local.getParent(), this._local.getName() + ".sha256");
        if (file.exists()) {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).strip();
        }
        return super.computeDigest(version, md, obs);
    }

    public boolean isMarkedValid() {
        File parent = new File(this._marker.getParent());
        if (!parent.exists() && !parent.mkdirs()) {
            Log.log.warning((Object)("Failed to create target directory for resource '" + this._marker + "'."), new Object[0]);
        }
        return super.isMarkedValid();
    }

    public void install(boolean validate) throws IOException {
        this.applyAttrs();
    }

    public void applyAttrs() throws IOException {
        if (this.shouldUnpack()) {
            this.unpack();
        }
        if (this._attrs.contains(Resource.Attr.EXEC)) {
            FileUtil.makeExecutable((File)this._localNew);
        }
    }

    public void unpack() throws IOException {
        if (!this._isZip) {
            throw new IOException("Requested to unpack not supported archive file '" + this._localNew + "'.");
        }
        String newFileName = this._localNew.getName() + ".sha256";
        MessageDigest digest = Digest.getMessageDigest((int)2);
        Utils.writeStringToFile(this._localNew.toPath().resolve(newFileName), TmmGetdownResource.computeDigest((int)2, (File)this._localNew, (MessageDigest)digest, null));
        if (this._isZip) {
            try (ZipFile jar = new ZipFile(this._localNew);){
                FileUtil.unpackJar((ZipFile)jar, (File)this._unpacked, (boolean)this._attrs.contains(Resource.Attr.CLEAN));
            }
        }
    }
}

