/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660.susp;

import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.UnknownSuspFieldId;

public abstract class SuspField {
    public int id;
    public int length;
    public int version;

    public abstract void deserialize(byte[] var1, int var2) throws InvalidSuspField;

    public abstract int getExpectedId();

    public void deserializeHeader(byte[] block, int bp) throws InvalidSuspField {
        if (block.length < 4) {
            throw new InvalidSuspField("SUSP field shall contain at least 4 bytes");
        }
        this.id = Util.getUInt16BE(block, bp);
        this.length = Util.getUInt8(block, bp + 2);
        this.version = Util.getUInt8(block, bp + 3);
    }

    public void verifyId() throws UnknownSuspFieldId {
        int expected;
        int id = this.getId();
        if (id != (expected = this.getExpectedId())) {
            String hexId = Integer.toHexString(id).toUpperCase();
            throw new UnknownSuspFieldId("Unexpected SUSP field id: 0x" + hexId);
        }
    }

    public int getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getVersion() {
        return this.version;
    }

    public static int extractFieldId(byte[] block, int bp) {
        return Util.getUInt16BE(block, bp);
    }
}

