/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringShortAdapter;
import org.tinymediamanager.library.bluray.clipinf.Subtitle;

@XmlType(propOrder={"const0x0001", "const0x0100", "subtitles"})
public class SubtitleAttr {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtitleAttr.class);
    private Short const0x0001;
    private Short const0x0100;
    private Subtitle[] subtitles;

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getConst0x0001() {
        return this.const0x0001;
    }

    public void setConst0x0001(Short s) {
        this.const0x0001 = s;
    }

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getConst0x0100() {
        return this.const0x0100;
    }

    public void setConst0x0100(Short s) {
        this.const0x0100 = s;
    }

    @XmlElement(name="Subtitle")
    public Subtitle[] getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(Subtitle[] subtitleArray) {
        this.subtitles = subtitleArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("SubtitleAttr length={}", (Object)n);
        this.const0x0001 = dataInputStream.readShort();
        LOGGER.trace("SubtitleAttr const0x0001={}", (Object)this.const0x0001);
        dataInputStream.skipBytes(4);
        this.const0x0100 = dataInputStream.readShort();
        LOGGER.trace("SubtitleAttr const0x0100={}", (Object)this.const0x0100);
        int n2 = dataInputStream.readByte();
        LOGGER.trace("SubtitleAttr number of subtitles={}", (Object)((byte)n2));
        dataInputStream.skipBytes(1);
        this.subtitles = new Subtitle[n2];
        for (int i = 0; i < n2; ++i) {
            this.subtitles[i] = new Subtitle();
            this.subtitles[i].readObject(dataInputStream);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n2 = this.getSubtitles() == null ? 0 : this.getSubtitles().length;
        dataOutputStream2.writeShort(this.getConst0x0001().shortValue());
        for (n = 0; n < 4; ++n) {
            dataOutputStream2.write(0);
        }
        dataOutputStream2.writeShort(this.getConst0x0100().shortValue());
        dataOutputStream2.write(n2);
        dataOutputStream2.write(0);
        for (n = 0; n < n2; ++n) {
            this.subtitles[n].writeObject(dataOutputStream2);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }
}

