/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.entities;

import javax.annotation.Nonnull;

public class UserSlug {
    public static final UserSlug ME = new UserSlug("me");
    private final String userSlug;

    public UserSlug(String userSlug) {
        if (userSlug == null) {
            throw new IllegalArgumentException("trakt user slug can not be null.");
        }
        if ((userSlug = userSlug.trim()).length() == 0) {
            throw new IllegalArgumentException("trakt user slug can not be empty.");
        }
        this.userSlug = userSlug;
    }

    @Nonnull
    public static UserSlug fromUsername(String username) {
        if (username == null) {
            throw new IllegalArgumentException("trakt username can not be null.");
        }
        String slug = username.replace(".", "-").replace(" ", "-").replaceAll("(-)+", "-");
        return new UserSlug(slug);
    }

    public String toString() {
        return this.userSlug;
    }
}

