/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private \u10ad digest;
    private \u0520 cipher;
    private \ua68b algId;

    protected DigestSignatureSpi(\u10ad \u2d0d2, \u0520 \u05212) {
        this.digest = \u2d0d2;
        this.cipher = \u05212;
        this.algId = null;
    }

    protected DigestSignatureSpi(\uff54 \uff542, \u10ad \u2d0d2, \u0520 \u05212) {
        this.digest = \u2d0d2;
        this.cipher = \u05212;
        this.algId = new \ua68b(\uff542, \ua726.\u0422);
    }

    @Override
    protected void engineInitVerify(PublicKey object) {
        if (!(object instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPublicKey instance");
        }
        object = \u1fe9.\u0422((RSAPublicKey)object);
        this.digest.\u0422();
        this.cipher.\u0422(false, (\u1f67)object);
    }

    @Override
    protected void engineInitSign(PrivateKey object) {
        if (!(object instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPrivateKey instance");
        }
        object = \u1fe9.\u0422((RSAPrivateKey)object);
        this.digest.\u0422();
        this.cipher.\u0422(true, (\u1f67)object);
    }

    private String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.digest.\u0422(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.\u0422(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() {
        byte[] byArray = new byte[this.digest.\u0422()];
        this.digest.\u0422(byArray, 0);
        try {
            byArray = this.derEncode(byArray);
            return this.cipher.\u0422(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        byte[] byArray2 = new byte[this.digest.\u0422()];
        this.digest.\u0422(byArray2, 0);
        try {
            byArray = this.cipher.\u0422(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            return \u2c61.\u0442(byArray, byArray2);
        }
        if (byArray.length == byArray2.length - 2) {
            int n;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n2 = 4 + byArray2[3];
            int n3 = n2 + 2;
            int n4 = 0;
            for (n = 0; n < byArray2.length - n3; ++n) {
                n4 |= byArray[n2 + n] ^ byArray2[n3 + n];
            }
            for (n = 0; n < n2; ++n) {
                n4 |= byArray[n] ^ byArray2[n];
            }
            return n4 == 0;
        }
        \u2c61.\u0442(byArray2, byArray2);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] byArray) {
        if (this.algId == null) {
            return byArray;
        }
        return new \ua68a(this.algId, byArray).\u0422("DER");
    }
}

