/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends \ua648 {
    @Override
    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        if (clazz.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            key = (RSAPublicKey)key;
            return new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            key = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(key.getModulus(), key.getPrivateExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            key = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
        }
        if (clazz.isAssignableFrom(\u2162.class) && key instanceof RSAPublicKey) {
            try {
                return new \u2162(\u021d.\u0422(new \u1e29(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\u2172.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \u2172(\u021c.\u0422(new \u0539(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\u2c80.class) && key instanceof RSAPublicKey) {
            try {
                return new \u2c80(\u021d.\u0422(new \u1e29(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\u0145.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \u0145(\u021c.\u0422(new \u0539(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    @Override
    protected Key engineTranslateKey(Key key) {
        if (key instanceof RSAPublicKey) {
            return new \u1fe1((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new \u1ed1((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new \u1ed0((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(\ua7a9.\u0422(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                try {
                    return new \u1ed1(\ua7a8.\u0422(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception2) {
                    throw new \ua649("unable to process key spec: " + exception.toString(), exception);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new \u1ed1((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new \u1ed0((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof \u2172) {
            \u04d6 \u04d72 = \u021c.\u0422(((\u2172)keySpec).getEncoded());
            if (\u04d72 instanceof \u0539) {
                return new \u1ed1((\u0539)\u04d72);
            }
            throw new InvalidKeySpecException("open SSH public key is not RSA private key");
        }
        throw new InvalidKeySpecException("unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec object) {
        if (object instanceof RSAPublicKeySpec) {
            return new \u1fe1((RSAPublicKeySpec)object);
        }
        if (object instanceof \u2162) {
            if ((object = \u021d.\u0422(((\u2162)object).getEncoded())) instanceof \u1e29) {
                return new \u1fe1((\u1e29)object);
            }
            throw new InvalidKeySpecException("Open SSH public key is not RSA public key");
        }
        return super.engineGeneratePublic((KeySpec)object);
    }

    @Override
    public PrivateKey generatePrivate(\ua7a9 \ua7a92) {
        \uff34 \uff542 = \ua7a92.\u0422.\u0422;
        if (\u1fe9.\u0422(\uff542)) {
            \uff542 = \ua7a8.\u0422(\ua7a92.\u0422());
            if (((\ua7a8)\uff542).\u2c9a.intValue() == 0) {
                return new \u1ed0(\ua7a92.\u0422, (\ua7a8)\uff542);
            }
            return new \u1ed1(\ua7a92);
        }
        throw new IOException("algorithm identifier " + \uff542 + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(\u020c \u020d2) {
        \uff54 \uff542 = \u020d2.\u0422.\u0422;
        if (\u1fe9.\u0422(\uff542)) {
            return new \u1fe1(\u020d2);
        }
        throw new IOException("algorithm identifier " + \uff542 + " in key not recognised");
    }
}

