/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.Device;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.X;
import com.ubnt.repository.do;
import java.util.Collections;
import java.util.List;

public class CrashLog
extends X
implements do {
    @ReferClasses
    public static final List<Class<?>> dodoString = Collections.emptyList();

    public static String name() {
        return "crashlog";
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    @Override
    public String getCollectionName() {
        return CrashLog.name();
    }

    public static int mask() {
        return intObject | \u00f4\u00d30000;
    }

    public String getAnonymousSiteId() {
        return this.getString("anonymous_site_id");
    }

    public CrashLog setAnonymousSiteId(String string) {
        this.put("anonymous_site_id", (Object)string);
        return this;
    }

    public String getAnonymousDeviceId() {
        return this.getString("anonymous_device_id");
    }

    public CrashLog setAnonymousDeviceId(String string) {
        this.put("anonymous_device_id", (Object)string);
        return this;
    }

    public String getDeviceType() {
        return this.getString("device_type");
    }

    public CrashLog setDeviceType(String string) {
        this.put("device_type", (Object)string);
        return this;
    }

    public boolean isCrashSentToAnalytics() {
        return this.getOptionalBoolean("crash_sent_to_analytics").orElse(false);
    }

    public CrashLog setCrashSentToAnalytics(boolean bl) {
        this.put("crash_sent_to_analytics", (Object)bl);
        return this;
    }

    public String getModel() {
        return this.getString("model");
    }

    public CrashLog setModel(String string) {
        this.put("model", (Object)string);
        return this;
    }

    public String getVersion() {
        return this.getString("version");
    }

    public CrashLog setVersion(String string) {
        this.put("version", (Object)string);
        return this;
    }

    public String getBoardRevision() {
        return this.getString("board_rev");
    }

    public CrashLog setBoardRevision(String string) {
        this.put("board_rev", (Object)string);
        return this;
    }

    public String getKernelVersion() {
        return this.getString("kernel_version");
    }

    public CrashLog setKernelVersion(String string) {
        this.put("kernel_version", (Object)string);
        return this;
    }

    public String getArchitecture() {
        return this.getString("architecture");
    }

    public CrashLog setArchitecture(String string) {
        this.put("architecture", (Object)string);
        return this;
    }

    public String getLog() {
        return this.getString("log");
    }

    public CrashLog setLog(String string) {
        this.put("log", (Object)string);
        return this;
    }

    public Long getCrashTimeMillis() {
        return this.getLongOrNull("datetime");
    }

    public CrashLog setCrashTimeMillis(Long l2) {
        this.put("datetime", (Object)l2);
        return this;
    }

    public String getSource() {
        return this.getString("source");
    }

    public CrashLog setSource(String string) {
        this.put("source", (Object)string);
        return this;
    }

    public Integer getManufacturerId() {
        return this.getIntOrNull("manufacturer_id");
    }

    public CrashLog setManufacturerId(int n2) {
        this.put("manufacturer_id", (Object)n2);
        return this;
    }

    public Long getUptime() {
        return this.getLongOrNull("uptime");
    }

    public CrashLog setUptime(Long l2) {
        this.put("uptime", (Object)l2);
        return this;
    }

    public Long getBootTime() {
        return this.getLongOrNull("boot_time");
    }

    public CrashLog setBootTime(Long l2) {
        this.put("boot_time", (Object)l2);
        return this;
    }

    public String getCpuStat() {
        return this.getString("cpu");
    }

    public String getMemoryStat() {
        return this.getString("mem");
    }

    public String getGeneralTemperatureStat() {
        return this.getString("general_temperature");
    }

    public String getFanLevelStat() {
        return this.getString("fan_level");
    }

    public CrashLog setTimeSeriesStats(X x2) {
        this.copyAttrsIfPresent(x2, "cpu", "mem", "general_temperature", "fan_level");
        return this;
    }

    public static CrashLog of(Device device) {
        CrashLog crashLog = new CrashLog().setAnonymousDeviceId(device.getAnonymousDeviceId()).setDeviceType(device.getDeviceType().toString()).setModel(device.getModel().toString()).setVersion(device.getFirmwareVersion()).setBoardRevision(device.getBoardRevision()).setKernelVersion(device.getKernelVersion()).setArchitecture(device.getArchitecture()).setUptime(device.getUptime()).setBootTime(device.getBootTime());
        device.getManufacturerId().ifPresent(crashLog::setManufacturerId);
        return crashLog;
    }
}

