/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.B;
import com.ubnt.data.FirewallGroupType;
import com.ubnt.data.FirewallRule;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.X;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.repository.do;
import com.ubnt.service.systemlog.admin.activity.changes.P;
import com.ubnt.service.systemlog.admin.activity.changes.returnsuper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class FirewallGroup
extends X
implements Sanitizable,
do,
returnsuper {
    public static final String ObjectnullObject = "firewallgroup";
    @ReferClasses
    public static final List<Class<?>> \u00d5\u00d2\u00d6000 = Collections.emptyList();
    public static final String \u00f5O\u00d6000 = "unifi_controller_addresses";
    public static final String \u00d2O\u00d6000 = "unifi_controller_ports-tcp";
    public static final String \u00d6o\u00d6000 = "unifi_controller_ports-udp";
    public static final String \u00d6O\u00d6000 = "unifi_talk_addresses";
    public static final String \u00f50\u00d6000 = "unifi_talk_ports";
    public static final String o\u00d3\u00d6000 = "guest_network";
    public static final String publicnullObject = "corporate_network";
    public static final String superintObject = "_corporate_network";
    public static final String voidnullObject = "local_network";
    public static final String \u00f4O\u00d6000 = "remote_user_vpn_network";
    public static final String dovoidObject = "remote_site_vpn_network";
    public static final String \u00f4o\u00d6000 = "remote_client_vpn_network";
    public static final String \u00f60\u00d6000 = "LTE_failover_network";
    public static final String \u00d6\u00d3\u00d6000 = "local_networkv6";
    public static final String o\u00d2\u00d6000 = "guest_networkv6";
    public static final String \u00f6\u00d2\u00d6000 = "corporate_networkv6";
    public static final String interfacevoidObject = "LTE_failover_networkv6";
    public static final String oo\u00d6000 = "ssl_inspection_subnets";
    public static final String \u00d2\u00d3\u00d6000 = "ssl_inspection_v6_subnets";
    public static final String \u00f5\u00d2\u00d6000 = "ssl_non_guest_subnets";
    public static final String \u00f40\u00d6000 = "ssl_non_guest_v6_subnets";
    public static final String \u00d60\u00d6000 = "ssl_guest_subnets";
    public static final String oO\u00d6000 = "ssl_guest_v6_subnets";
    public static final String floatnullObject = "guest_pre_allow";
    public static final String \u00d4O\u00d6000 = "guest_restricted";
    public static final String \u00d5O\u00d6000 = "guest_allow_dns_servers";
    public static final String OO\u00d6000 = "authorized_guests";
    public static final String \u00d5o\u00d6000 = "guest_portal_address";
    public static final String \u00f5o\u00d6000 = "guest_portal_ports";
    public static final String Oo\u00d6000 = "guest_portal_redirector_ports";
    public static final String \u00d6\u00d2\u00d6000 = "captive_portal_subnets";
    public static final String \u00d5\u00d3\u00d6000 = "ipsec_ports";
    public static final String O\u00d3\u00d6000 = "l2tp_port";
    public static final String classvoidObject = "openvpn_tcp_ports";
    public static final String \u00f6O\u00d6000 = "openvpn_udp_ports";
    public static final String \u00d4o\u00d6000 = "wireguard_ports";
    public static final String \u00d2o\u00d6000 = "unifi_console_https_port";
    public static final String \u00f6o\u00d6000 = "ipsec_remote_subnets";
    public static final String supervoidObject = "isolated_subnets";
    public static final String intvoidObject = "isolated_subnetsv6";
    public static final String classintObject = "skip_nat_subnets";
    public static final String \u00d4\u00d3\u00d6000 = "mdns_addresses_name";
    public static final String dointObject = "mdns_ports_name";
    public static final String[] \u00d2\u00d2\u00d6000 = new String[]{"guest_pre_allow", "guest_restricted", "guest_allow_dns_servers", "authorized_guests", "guest_portal_address", "unifi_controller_addresses"};
    public static final String[] intintObject = new String[]{"guest_portal_ports", "guest_portal_redirector_ports", "unifi_controller_ports-tcp", "unifi_controller_ports-udp"};
    public static final String \u00f4\u00d2\u00d6000 = "group_members";
    public static final String O\u00d2\u00d6000 = "group_type";
    public static B \u00d4\u00d2\u00d6000 = B.\u00d6\u00f4\u00f5000(FirewallGroup.class.getSimpleName());

    public static String name() {
        return ObjectnullObject;
    }

    @Override
    public String getCollectionName() {
        return FirewallGroup.name();
    }

    @Override
    public AdminChangeSection getSection() {
        return AdminChangeSection.FIREWALL_GROUP;
    }

    @Override
    public AdminChangeKey getChangeKey() {
        return AdminChangeKey.SECURITY;
    }

    @Override
    public Optional<P> getDepiction() {
        return P.\u00d400000("name", this.getName());
    }

    public static int mask() {
        return intObject | O\u00d30000;
    }

    @Override
    public void sanitize(X x2) {
        \u00d4\u00d2\u00d6000.interfacenewclass(x2);
    }

    public static String getOverlappingPortMember(List<String> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : list) {
            int n2;
            X x2 = FirewallRule.parsePortOptions(string);
            if (x2 == null) continue;
            if (x2.containsField("port_numbered")) {
                n2 = x2.getInt("port_numbered");
                if (arrayList.contains(n2)) {
                    return string;
                }
                arrayList.add(n2);
            }
            if (!x2.containsField("port_range_start") || !x2.containsField("port_range_end")) continue;
            n2 = x2.getInt("port_range_start");
            int n3 = x2.getInt("port_range_end");
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (arrayList.contains(i2)) {
                    return string;
                }
                arrayList.add(i2);
            }
        }
        return "";
    }

    public FirewallGroup setGroupType(FirewallGroupType firewallGroupType) {
        this.put(O\u00d2\u00d6000, (Object)firewallGroupType.toString());
        return this;
    }

    public boolean isIpv4AddressGroup() {
        return StringUtils.equals((CharSequence)this.getString(O\u00d2\u00d6000), (CharSequence)FirewallGroupType.\u00d200000.toString());
    }

    public boolean isIpv6AddressGroup() {
        return StringUtils.equals((CharSequence)this.getString(O\u00d2\u00d6000), (CharSequence)FirewallGroupType.o00000.toString());
    }

    public boolean isPortGroup() {
        return StringUtils.equals((CharSequence)this.getString(O\u00d2\u00d6000), (CharSequence)FirewallGroupType.\u00d500000.toString());
    }

    public boolean containsPort(String string) {
        return this.isPortGroup() && this.getStringList(\u00f4\u00d2\u00d6000).contains(string);
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    public FirewallGroup setId(String string) {
        this.put("_id", (Object)string);
        return this;
    }

    public String getName() {
        return this.getString("name");
    }

    public FirewallGroup setName(String string) {
        this.put("name", (Object)string);
        return this;
    }

    public List<String> getMembers() {
        return this.getStringList(\u00f4\u00d2\u00d6000);
    }
}

