/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.alert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OoOO.C;
import com.ubnt.model.api.alert.ImmutableAlertDtoParameters;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.service.alert.ParameterDataDocumentPart;
import com.ubnt.service.uidb.oooO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableAlertDtoParameters.class)
@Value.Immutable
@C
public interface AlertDtoParameters {
    @JsonProperty(value="id")
    @Schema(name="ID of the referenced entity")
    public String id();

    @JsonProperty(value="name")
    @Schema(name="Name of the referenced entity")
    public String name();

    @JsonProperty(value="model")
    @Schema(name="Model sku of the referenced entity")
    public Optional<String> model();

    @JsonProperty(value="model_name")
    @Schema(name="Model name of the referenced entity")
    public Optional<String> modelName();

    @JsonProperty(value="fingerprint_source")
    @Schema(name="Fingerprint engine ID", example="0")
    public Optional<Integer> fingerprintSource();

    @JsonProperty(value="device_fingerprint_id")
    @Schema(name="Fingerprinting device ID", example="1")
    public Optional<Integer> deviceFingerprintId();

    @JsonProperty(value="network_purpose")
    @Schema(name="Network Purpose", example="site-vpn")
    public Optional<NetworkPurpose> networkPurpose();

    @JsonProperty(value="unifi_device_fingerprint_icon_filename")
    @Schema(name="Icon filename", example="b8e2127c-239b-4686-99e6-1872c5b4749a")
    public Optional<String> unifiDeviceFingerprintIconFilename();

    @JsonProperty(value="unifi_device_fingerprint_icon_resolutions")
    @Schema(name="Supported icon resolutions", example="[[257, 257], [129, 129], [101, 101], [51, 51], [25, 25]]")
    public Optional<List<List<Integer>>> unifiDeviceFingerprintIconResolutions();

    @JsonProperty(value="not_actionable")
    @Schema(name="System log parameter not actionable", example="true")
    public Optional<Boolean> notActionable();

    @JsonProperty(value="radio_band")
    @Schema(name="radio band of the referenced entity")
    public Optional<String> radioBand();

    public static ImmutableAlertDtoParameters.Builder builder() {
        return ImmutableAlertDtoParameters.builder();
    }

    public static AlertDtoParameters fromDocument(ParameterDataDocumentPart parameterDataDocumentPart, oooO oooO2) {
        return AlertDtoParameters.builder().id(parameterDataDocumentPart.getTargetId()).name(parameterDataDocumentPart.getName()).model(Optional.ofNullable(parameterDataDocumentPart.getModel())).modelName(oooO2.do(parameterDataDocumentPart.getModel()).map(Enum::name)).fingerprintSource(parameterDataDocumentPart.getFingerprintSource()).deviceFingerprintId(parameterDataDocumentPart.getDeviceFingerprintId()).networkPurpose(parameterDataDocumentPart.getNetworkPurpose()).unifiDeviceFingerprintIconFilename(parameterDataDocumentPart.getUnifiDeviceFingerprintIconFilename()).unifiDeviceFingerprintIconResolutions(parameterDataDocumentPart.getUnifiDeviceFingerprintIconResolutions()).notActionable(parameterDataDocumentPart.getNotActionable()).radioBand(parameterDataDocumentPart.getRadioBand()).build();
    }
}

