/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.apgroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.apgroup.ApGroupDocument;
import com.ubnt.service.config.OO0O;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Access Points Group")
public class ApGroup
implements OO0O {
    public static final int MAX_WLANCONF = 8;
    public static final int MAX_WLANCONF_WITH_WIRELESS_UPLINK = 4;
    public static final int MAX_WLANCONF_LIMITED_RESOURCES = 3;
    public static final int MAX_ACL_MAC_FILTER_NUMBER = 512;
    @JsonProperty(value="_id")
    @Schema(example="5e6285ec05938c3d128aaf07", accessMode=Schema.AccessMode.READ_ONLY)
    private String id;
    @JsonIgnore
    private String siteId;
    @JsonProperty(value="attr_hidden_id")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Null
    private String hiddenId;
    @JsonProperty(value="attr_no_delete")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @AssertFalse
    private boolean nonDeletable;
    @JsonProperty(value="name")
    @NotEmpty
    private String name;
    @JsonProperty(value="device_macs")
    @NotNull
    @MacAddress
    @Schema(required=true, name="List of device macs. will be ignored when updating default AP group", example="[\"04:18:d6:a0:bc:52\"]")
    private Set<String> deviceMACs;
    @JsonProperty(value="for_wlanconf")
    @Schema(description="Mark AP Group as dedicated for a single WLAN Conf (Devices view). It will be hidden from list results by default for backward compatibility, but possible to enable optionally")
    private boolean forWlanConf;

    public String getId() {
        return this.id;
    }

    public ApGroup setId(String string) {
        this.id = string;
        return this;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public ApGroup setSiteId(String string) {
        this.siteId = string;
        return this;
    }

    public Optional<String> getHiddenId() {
        return Optional.ofNullable(this.hiddenId);
    }

    public ApGroup setHiddenId(String string) {
        this.hiddenId = string;
        return this;
    }

    public boolean isNonDeletable() {
        return this.nonDeletable;
    }

    public ApGroup setNonDeletable(boolean bl) {
        this.nonDeletable = bl;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ApGroup setName(String string) {
        this.name = string;
        return this;
    }

    public Set<String> getDeviceMACs() {
        return this.deviceMACs;
    }

    public ApGroup setDeviceMACs(Set<String> set) {
        this.deviceMACs = set;
        return this;
    }

    @JsonIgnore
    public boolean isDefault() {
        return "default".equals(this.hiddenId);
    }

    public boolean isForWlanConf() {
        return this.forWlanConf;
    }

    public ApGroup setForWlanConf(boolean bl) {
        this.forWlanConf = bl;
        return this;
    }

    public static ApGroup fromDocument(ApGroupDocument apGroupDocument) {
        ApGroup apGroup = new ApGroup();
        apGroup.id = apGroupDocument.getId();
        apGroup.siteId = apGroupDocument.getSiteId();
        apGroup.name = apGroupDocument.getName();
        apGroup.hiddenId = apGroupDocument.getHiddenId();
        apGroup.nonDeletable = apGroupDocument.isNonDeletable();
        apGroup.forWlanConf = apGroupDocument.isForWlanConf();
        Set<String> set = apGroupDocument.getDeviceMACs();
        if (set != null) {
            apGroup.deviceMACs = Set.copyOf(set);
        }
        return apGroup;
    }

    public ApGroupDocument toDocument(String string) {
        return ApGroupDocument.of(this.id, string, this.hiddenId, this.name, this.nonDeletable, this.deviceMACs, this.forWlanConf);
    }
}

