/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.bgp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OoOO.return;
import com.ubnt.model.api.bgp.ImmutableBgpRouterDto;
import com.ubnt.service.bgp.BgpRouterDocument;
import com.ubnt.service.bgp.C;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Schema(name="BGP")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableBgpRouterDto.class)
@Value.Immutable
@return
public interface BgpRouterDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="device_mac")
    public Optional<String> deviceMac();

    @JsonProperty(value="description")
    public Optional<String> description();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="frr_bgpd_config")
    @NotEmpty
    public String frrBgpdConfig();

    @JsonProperty(value="uploaded_file_name")
    @NotEmpty
    public String uploadedFileName();

    public static ImmutableBgpRouterDto.Builder builder() {
        return ImmutableBgpRouterDto.builder();
    }

    public static BgpRouterDto ofDocument(BgpRouterDocument bgpRouterDocument) {
        return BgpRouterDto.builder().id(bgpRouterDocument.getId()).deviceMac(bgpRouterDocument.getDeviceMac()).description(bgpRouterDocument.getDescription()).frrBgpdConfig(bgpRouterDocument.getFrrBgpdConfig()).enabled(bgpRouterDocument.getEnabled()).uploadedFileName(bgpRouterDocument.getUploadedFileName()).build();
    }

    default public BgpRouterDocument toDocument(String string) {
        return this.documentBuilder(string).\u00f400000();
    }

    default public BgpRouterDocument toDocument(String string, String string2) {
        return this.documentBuilder(string).o00000(string2).\u00f400000();
    }

    default public C documentBuilder(String string) {
        return BgpRouterDocument.builder().\u00d600000(string).void(this.id()).\u00d500000(this.enabled()).\u00d400000(this.frrBgpdConfig()).\u00d200000(this.description().orElse(null)).Object(this.uploadedFileName());
    }
}

