/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.OoOO.C;
import com.ubnt.model.api.dashboard.ImmutableWifiActivityWidgetDto;
import com.ubnt.model.api.dashboard.WifiActivityStatDto;
import com.ubnt.model.api.dashboard.widgets.DashboardWidget;
import com.ubnt.model.api.dashboard.widgets.DashboardWidgetDto;
import com.ubnt.model.api.dashboard.widgets.NoStatsReason;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@C
public interface WifiActivityWidgetDto
extends DashboardWidgetDto {
    @Override
    default public DashboardWidget type() {
        return DashboardWidget.WIFI_ACTIVITY;
    }

    @JsonProperty(value="history")
    public List<WifiActivityStatDto> wifiActivityStats();

    @JsonProperty(value="rx_bytes")
    public Optional<Long> receivedBytes();

    @JsonProperty(value="tx_bytes")
    public Optional<Long> transmittedBytes();

    @JsonProperty(value="no_stats_reason")
    public Optional<NoStatsReason> noStatsReason();

    public static WifiActivityWidgetDto of(List<WifiActivityStatDto> list) {
        long l2 = list.stream().mapToLong(WifiActivityStatDto::rxBytes).sum();
        long l3 = list.stream().mapToLong(WifiActivityStatDto::txBytes).sum();
        return ImmutableWifiActivityWidgetDto.builder().wifiActivityStats(list).receivedBytes(l2).transmittedBytes(l3).build();
    }

    public static WifiActivityWidgetDto withoutStats(NoStatsReason noStatsReason) {
        return ImmutableWifiActivityWidgetDto.builder().wifiActivityStats(List.of()).noStatsReason(noStatsReason).build();
    }
}

