/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.device.battery;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Model;
import com.ubnt.model.api.device.battery.ImmutableBatteryTableEntryDto;
import com.ubnt.service.devmgr.device.battery.C;
import com.ubnt.service.devmgr.device.battery.G;
import com.ubnt.service.devmgr.device.battery.if;
import com.ubnt.service.devmgr.device.battery.int;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@com.ubnt.OoOO.C
public interface BatteryTableEntryDto {
    @JsonProperty(value="batteryAnomaly")
    public int anomaly();

    @JsonProperty(value="batteryHealth")
    public int healthPercentage();

    @JsonProperty(value="batteryMA")
    public int milliAmpere();

    @JsonProperty(value="batteryMV")
    public int milliVolt();

    @JsonProperty(value="client_state")
    public G state();

    @JsonProperty(value="client_update_progress")
    public int updateProgressPercentage();

    @JsonProperty(value="client_update_result")
    public int updateResult();

    @JsonProperty(value="fwv")
    public String firmwareVersion();

    @JsonProperty(value="health")
    public if healthStatus();

    @JsonProperty(value="isBadBattery")
    public boolean isBadBattery();

    @JsonProperty(value="id")
    public String mac();

    @JsonProperty(value="model")
    public Model model();

    @JsonProperty(value="uptime")
    public int uptime();

    @JsonProperty(value="upgradable")
    public boolean upgradable();

    @JsonProperty(value="upgrade_to_firmware")
    public Optional<String> upgradeToFirmware();

    @JsonProperty(value="isLocating")
    public boolean isLocating();

    @JsonProperty(value="upgradeDuration")
    public int upgradeDuration();

    public static ImmutableBatteryTableEntryDto.Builder builder() {
        return ImmutableBatteryTableEntryDto.builder();
    }

    public static List<BatteryTableEntryDto> of(List<C> list) {
        return list.stream().map(BatteryTableEntryDto::of).toList();
    }

    public static BatteryTableEntryDto of(C c2) {
        return BatteryTableEntryDto.builder().anomaly(c2.\u00f400000()).healthPercentage(c2.return()).milliAmpere(c2.while()).milliVolt(c2.\u00d5O0000()).state(c2.\u00d3O0000()).updateProgressPercentage(c2.\u00d500000()).updateResult(c2.\u00d300000()).firmwareVersion(c2.\u00f800000()).healthStatus(c2.OO0000()).isBadBattery(c2.o00000()).mac(c2.\u00d400000()).model(c2.oO0000()).uptime(c2.\u00d4O0000()).upgradable(c2.new()).upgradeToFirmware(c2.\u00f500000()).isLocating(c2.thissuper()).upgradeDuration(c2.if()).build();
    }
}

