/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.firewall.qos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OoOO.return;
import com.ubnt.model.api.firewall.policy.FirewallPolicyScheduleDto;
import com.ubnt.model.api.firewall.qos.ImmutableQosRuleDto;
import com.ubnt.model.api.firewall.qos.destination.FirewallQosDestinationDto;
import com.ubnt.model.api.firewall.qos.source.FirewallQosSourceDto;
import com.ubnt.service.firewall.qos.QosRuleDocument;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableQosRuleDto.Builder.class)
@Value.Immutable(copy=true)
@return
public interface QosRuleDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="index")
    public int index();

    @JsonProperty(value="source")
    @Valid
    @NotNull
    public FirewallQosSourceDto source();

    @JsonProperty(value="destination")
    @Valid
    @NotNull
    public FirewallQosDestinationDto destination();

    @JsonProperty(value="wan_or_vpn_network")
    @Valid
    public Optional<String> wanOrVpnNetwork();

    @JsonProperty(value="download_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer downloadLimitKbps();

    @JsonProperty(value="upload_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer uploadLimitKbps();

    @JsonProperty(value="schedule")
    @Valid
    @NotNull
    public FirewallPolicyScheduleDto schedule();

    public static ImmutableQosRuleDto.Builder builder() {
        return ImmutableQosRuleDto.builder();
    }

    public static QosRuleDto fromDocument(QosRuleDocument qosRuleDocument) {
        return ImmutableQosRuleDto.builder().id(qosRuleDocument.getId()).enabled(qosRuleDocument.isEnabled()).name(qosRuleDocument.getName()).index(qosRuleDocument.getIndex()).source(FirewallQosSourceDto.fromDocument(qosRuleDocument.getSource())).destination(FirewallQosDestinationDto.fromDocument(qosRuleDocument.getDestination())).wanOrVpnNetwork(qosRuleDocument.getWanOrVpnNetwork()).downloadLimitKbps(qosRuleDocument.getDownloadLimitKbps()).uploadLimitKbps(qosRuleDocument.getUploadLimitKbps()).schedule(FirewallPolicyScheduleDto.fromDocument(qosRuleDocument.getSchedule())).build();
    }

    default public QosRuleDocument toDocument(String string) {
        return QosRuleDocument.builder().String(this.id()).oO0000(this.enabled()).\u00f500000(this.name()).\u00d600000(this.index()).\u00d200000(this.destination().toDocument()).\u00f800000(this.source().toDocument()).\u00d300000(this.wanOrVpnNetwork().orElse(null)).null(this.downloadLimitKbps()).\u00d800000(this.uploadLimitKbps()).o00000(this.schedule().toDocument()).\u00f600000(string).for();
    }

    public static QosRuleDto withId(QosRuleDto qosRuleDto, String string) {
        return ImmutableQosRuleDto.copyOf(qosRuleDto).withId(string);
    }
}

