/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.inspection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.inspection.InspectionLogDto;
import com.ubnt.model.api.inspection.InspectionLogsListDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Inspection logs list with paging info")
@Generated(from="InspectionLogsListDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableInspectionLogsListDto
implements InspectionLogsListDto {
    private final List<InspectionLogDto> data;
    private final long totalElementCount;
    private final int totalPageCount;
    private final int pageNumber;
    @Nullable
    private final Boolean orMore;
    @Nullable
    private final Boolean hasNext;

    private ImmutableInspectionLogsListDto(Builder builder) {
        this.data = ImmutableInspectionLogsListDto.O\u00d60000(true, builder.data);
        this.totalElementCount = builder.totalElementCount;
        this.totalPageCount = builder.totalPageCount;
        this.pageNumber = builder.pageNumber;
        this.orMore = builder.orMore;
        this.hasNext = builder.hasNext;
    }

    @Override
    public List<InspectionLogDto> data() {
        return this.data;
    }

    @Override
    @Schema(description="Number of total matched elements searching by the given criteria", example="1")
    public long totalElementCount() {
        return this.totalElementCount;
    }

    @Override
    public int totalPageCount() {
        return this.totalPageCount;
    }

    @Override
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    @Schema(description="True if there can be more elements than based on the total number of page")
    public Optional<Boolean> orMore() {
        return Optional.ofNullable(this.orMore);
    }

    @Override
    public Optional<Boolean> hasNext() {
        return Optional.ofNullable(this.hasNext);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableInspectionLogsListDto && this.whileString(0, (ImmutableInspectionLogsListDto)object);
    }

    private boolean whileString(int n2, ImmutableInspectionLogsListDto immutableInspectionLogsListDto) {
        return this.data.equals(immutableInspectionLogsListDto.data) && this.totalElementCount == immutableInspectionLogsListDto.totalElementCount && this.totalPageCount == immutableInspectionLogsListDto.totalPageCount && this.pageNumber == immutableInspectionLogsListDto.pageNumber && Objects.equals(this.orMore, immutableInspectionLogsListDto.orMore) && Objects.equals(this.hasNext, immutableInspectionLogsListDto.hasNext);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.data.hashCode();
        n2 += (n2 << 5) + Long.hashCode(this.totalElementCount);
        n2 += (n2 << 5) + this.totalPageCount;
        n2 += (n2 << 5) + this.pageNumber;
        n2 += (n2 << 5) + Objects.hashCode(this.orMore);
        n2 += (n2 << 5) + Objects.hashCode(this.hasNext);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("InspectionLogsListDto{");
        stringBuilder.append("data=").append(this.data);
        stringBuilder.append(", ");
        stringBuilder.append("totalElementCount=").append(this.totalElementCount);
        stringBuilder.append(", ");
        stringBuilder.append("totalPageCount=").append(this.totalPageCount);
        stringBuilder.append(", ");
        stringBuilder.append("pageNumber=").append(this.pageNumber);
        if (this.orMore != null) {
            stringBuilder.append(", ");
            stringBuilder.append("orMore=").append(this.orMore);
        }
        if (this.hasNext != null) {
            stringBuilder.append(", ");
            stringBuilder.append("hasNext=").append(this.hasNext);
        }
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> o\u00d60000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> O\u00d60000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="InspectionLogsListDto", generator="Immutables")
    public static final class Builder {
        private List<InspectionLogDto> data = new ArrayList<InspectionLogDto>();
        private long totalElementCount;
        private int totalPageCount;
        private int pageNumber;
        @Nullable
        private Boolean orMore;
        @Nullable
        private Boolean hasNext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InspectionLogsListDto inspectionLogsListDto) {
            Optional<Boolean> optional;
            Objects.requireNonNull(inspectionLogsListDto, "instance");
            this.addAllData(inspectionLogsListDto.data());
            this.totalElementCount(inspectionLogsListDto.totalElementCount());
            this.totalPageCount(inspectionLogsListDto.totalPageCount());
            this.pageNumber(inspectionLogsListDto.pageNumber());
            Optional<Boolean> optional2 = inspectionLogsListDto.orMore();
            if (optional2.isPresent()) {
                this.orMore(optional2);
            }
            if ((optional = inspectionLogsListDto.hasNext()).isPresent()) {
                this.hasNext(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(@Nullable InspectionLogDto inspectionLogDto) {
            this.data.add(inspectionLogDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(InspectionLogDto ... inspectionLogDtoArray) {
            for (InspectionLogDto inspectionLogDto : inspectionLogDtoArray) {
                this.data.add(inspectionLogDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(Iterable<? extends InspectionLogDto> iterable) {
            this.data.clear();
            return this.addAllData(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllData(Iterable<? extends InspectionLogDto> iterable) {
            for (InspectionLogDto inspectionLogDto : iterable) {
                this.data.add(inspectionLogDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalElementCount(long l2) {
            this.totalElementCount = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalPageCount(int n2) {
            this.totalPageCount = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pageNumber(int n2) {
            this.pageNumber = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(@Nullable Boolean bl) {
            this.orMore = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(Optional<Boolean> optional) {
            this.orMore = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(@Nullable Boolean bl) {
            this.hasNext = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(Optional<Boolean> optional) {
            this.hasNext = optional.orElse(null);
            return this;
        }

        public ImmutableInspectionLogsListDto build() {
            return new ImmutableInspectionLogsListDto(this);
        }
    }
}

