/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.inspection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.inspection.AdBlockInspectionLogDto;
import com.ubnt.model.api.inspection.FirewallInspectionLogDto;
import com.ubnt.model.api.inspection.InspectionLogSource;
import com.ubnt.model.api.inspection.SslInspectionLogDto;
import com.ubnt.model.api.inspection.ThreatInspectionLogDto;
import com.ubnt.model.api.inspection.UnknownInspectionLogType;
import com.ubnt.net.v2.exception.NotImplemented;
import com.ubnt.service.client.A.O00O;
import com.ubnt.service.client.A.Z;
import com.ubnt.service.inspectionlogs.InspectionLogDocument;
import com.ubnt.service.inspectionlogs.P;
import com.ubnt.service.inspectionlogs.String;
import com.ubnt.service.inspectionlogs.T;
import com.ubnt.service.systemlog.threat.ThreatLogDocument;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public interface InspectionLogDto {
    @JsonProperty(value="_id")
    public java.lang.String id();

    @JsonProperty(value="time")
    public long time();

    @JsonProperty(value="log_source")
    public InspectionLogSource logSource();

    @JsonProperty(value="client_mac")
    public Optional<java.lang.String> clientMac();

    @JsonProperty(value="client_name")
    public Optional<java.lang.String> clientName();

    @JsonProperty(value="client_fingerprint")
    public Optional<O00O> clientFingerprint();

    @JsonProperty(value="client_port")
    public Optional<Integer> clientPort();

    @JsonProperty(value="client_ip")
    public Optional<java.lang.String> clientIp();

    @JsonProperty(value="server_port")
    public Optional<Integer> serverPort();

    @JsonProperty(value="action")
    public String action();

    @JsonProperty(value="domain_name")
    public Optional<java.lang.String> domainName();

    @JsonProperty(value="risk")
    public Optional<P> risk();

    public static InspectionLogDto fromInspectionLogDocument(InspectionLogDocument inspectionLogDocument, T t2) {
        return switch (inspectionLogDocument.getLogSource()) {
            default -> throw new IncompatibleClassChangeError();
            case InspectionLogSource.SSL_INSPECT, InspectionLogSource.SSL_QUERY, InspectionLogSource.SSL_URL, InspectionLogSource.SSL_APP, InspectionLogSource.SSL_FILE, InspectionLogSource.SSL_BYPASS, InspectionLogSource.SSL_CERTIFICATE, InspectionLogSource.SSL_RISK_BLOCK -> SslInspectionLogDto.fromDocument(inspectionLogDocument, t2);
            case InspectionLogSource.FIREWALL_RULE, InspectionLogSource.TRAFFIC_RULE, InspectionLogSource.SIMPLE_APP_BLOCK, InspectionLogSource.FIREWALL_POLICY -> FirewallInspectionLogDto.fromDocument(inspectionLogDocument, t2);
            case InspectionLogSource.AD_BLOCK -> AdBlockInspectionLogDto.fromDocument(inspectionLogDocument, t2);
            case InspectionLogSource.CONTENT_FILTER -> throw new NotImplemented();
            case InspectionLogSource.THREAT_DETECTION, InspectionLogSource.UNKNOWN -> throw new UnknownInspectionLogType();
        };
    }

    public static InspectionLogDto fromThreatLogDocument(ThreatLogDocument threatLogDocument, Z z2) {
        return ThreatInspectionLogDto.fromDocument(threatLogDocument, z2);
    }
}

