/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.inspection;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.OoOO.C;
import com.ubnt.model.api.inspection.ImmutableThreatInspectionLogDto;
import com.ubnt.model.api.inspection.InspectionLogDto;
import com.ubnt.model.api.inspection.InspectionLogSource;
import com.ubnt.service.client.A.Z;
import com.ubnt.service.ips.private;
import com.ubnt.service.systemlog.threat.L;
import com.ubnt.service.systemlog.threat.ThreatLogDocument;
import jakarta.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@C
public interface ThreatInspectionLogDto
extends InspectionLogDto {
    @JsonProperty(value="alarm_id")
    public String alarmId();

    @JsonProperty(value="signature")
    public String signature();

    @JsonProperty(value="counterpart_location")
    public String counterpartLocation();

    @JsonProperty(value="server_ip")
    public String serverIp();

    @JsonProperty(value="threat_direction")
    public private threatDirection();

    @JsonProperty(value="counterpart_country_code")
    public String counterpartCountryCode();

    @JsonProperty(value="signature_type")
    public L signatureType();

    @JsonProperty(value="enhanced_detection")
    public boolean enhancedDetection();

    public static ThreatInspectionLogDto fromDocument(ThreatLogDocument threatLogDocument, @Nullable Z z2) {
        ImmutableThreatInspectionLogDto.Builder builder = ThreatInspectionLogDto.builder().id(threatLogDocument.getId()).logSource(InspectionLogSource.THREAT_DETECTION).clientMac(threatLogDocument.getClientMac()).serverIp(threatLogDocument.getCounterpart()).alarmId(threatLogDocument.getAlarmId()).risk(threatLogDocument.getSeverity().\u00d300000()).action(threatLogDocument.getAction().class()).signature(threatLogDocument.getSignature()).counterpartLocation(threatLogDocument.getCounterpartLocation()).counterpartCountryCode(threatLogDocument.getCounterpartCountryCode()).threatDirection(threatLogDocument.getThreatDirection()).domainName(threatLogDocument.getDomain()).signatureType(threatLogDocument.getSignatureType().orElse(L.Object)).enhancedDetection(threatLogDocument.getEnhancedDetection().orElse(false)).time(threatLogDocument.getTimestamp() / 1000L);
        if (z2 != null) {
            builder.clientName(z2.O\u00d20000()).clientFingerprint(z2.\u00d4o0000());
        }
        return builder.build();
    }

    public static ImmutableThreatInspectionLogDto.Builder builder() {
        return ImmutableThreatInspectionLogDto.builder();
    }
}

