/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.mclag;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OoOO.return;
import com.ubnt.model.api.mclag.ImmutableMcLagGroupDto;
import com.ubnt.model.api.mclag.LinkAggregationGroupPairDto;
import com.ubnt.model.api.mclag.McLagPeersDto;
import com.ubnt.service.mclag.McLagGroupDocument;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Comparator;
import java.util.List;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableMcLagGroupDto.class)
@JsonDeserialize(as=ImmutableMcLagGroupDto.class)
@Value.Immutable(copy=true)
@return
public interface McLagGroupDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="description")
    public String description();

    @JsonProperty(value="peers")
    @NotNull
    @Valid
    public McLagPeersDto peers();

    @JsonProperty(value="stacking")
    @Value.Default
    default public boolean stacking() {
        return false;
    }

    @JsonProperty(value="mc_link")
    @NotNull
    @Valid
    public LinkAggregationGroupPairDto mcLink();

    @JsonProperty(value="target_links")
    public @NotNull List<@Valid LinkAggregationGroupPairDto> targetLinks();

    default public McLagGroupDocument toSortedDocument(String string) {
        return McLagGroupDocument.builder().\u00d800000(this.id()).null(string).\u00d600000(this.name()).\u00f600000(this.description()).String(this.peers().toDocument()).\u00d200000(this.stacking()).for(this.mcLink().toSortedDocument()).o00000(this.targetLinks().stream().map(LinkAggregationGroupPairDto::toSortedDocument).sorted(Comparator.comparingInt(linkAggregationGroupPairDocumentPart -> linkAggregationGroupPairDocumentPart.getPortIndicesOnTopSwitch().get(0))).toList()).\u00f500000();
    }

    public static ImmutableMcLagGroupDto.Builder builder() {
        return ImmutableMcLagGroupDto.builder();
    }

    public static McLagGroupDto withId(McLagGroupDto mcLagGroupDto, String string) {
        return ImmutableMcLagGroupDto.copyOf(mcLagGroupDto).withId(string);
    }

    public static McLagGroupDto fromDocument(McLagGroupDocument mcLagGroupDocument) {
        return ImmutableMcLagGroupDto.builder().id(mcLagGroupDocument.getId()).name(mcLagGroupDocument.getName()).description(mcLagGroupDocument.getDescription()).peers(McLagPeersDto.fromDocument(mcLagGroupDocument.getPeers())).stacking(mcLagGroupDocument.isStacking()).mcLink(LinkAggregationGroupPairDto.fromDocument(mcLagGroupDocument.getMcLink())).targetLinks(mcLagGroupDocument.getTargetLinks().stream().map(LinkAggregationGroupPairDto::fromDocument).toList()).build();
    }
}

