/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.nat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OoOO.return;
import com.ubnt.model.api.nat.ImmutableNatRuleDto;
import com.ubnt.model.api.nat.NatRuleFilterDto;
import com.ubnt.service.nat.G;
import com.ubnt.service.nat.NatRuleDocument;
import com.ubnt.service.nat.o0OO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Schema(name="NAT Rules")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableNatRuleDto.class)
@Value.Immutable
@return
public interface NatRuleDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="type")
    public com.ubnt.service.nat.return type();

    @JsonProperty(value="description")
    public String description();

    @JsonProperty(value="protocol")
    public String protocol();

    @JsonProperty(value="in_interface")
    public String inInterface();

    @JsonProperty(value="out_interface")
    public String outInterface();

    @JsonProperty(value="ip_address")
    public String ipAddress();

    @JsonProperty(value="port")
    public String port();

    @JsonProperty(value="source_filter")
    public NatRuleFilterDto sourceFilter();

    @JsonProperty(value="destination_filter")
    public NatRuleFilterDto destinationFilter();

    @JsonProperty(value="logging")
    public boolean logging();

    @JsonProperty(value="exclude")
    public boolean exclude();

    @JsonProperty(value="setting_preference")
    public o0OO settingPreference();

    @JsonProperty(value="rule_index")
    @Min(value=0L)
    public @Min(value=0L) Integer ruleIndex();

    @JsonProperty(value="is_predefined")
    public boolean isPredefined();

    public static ImmutableNatRuleDto.Builder builder() {
        return ImmutableNatRuleDto.builder();
    }

    public static NatRuleDto ofDocument(NatRuleDocument natRuleDocument) {
        return NatRuleDto.builder().id(natRuleDocument.getId()).enabled(natRuleDocument.isEnabled()).type(natRuleDocument.getType()).description(natRuleDocument.getDescription()).protocol(natRuleDocument.getProtocol()).inInterface(natRuleDocument.getInNetworkConfId()).outInterface(natRuleDocument.getOutNetworkConfId()).ipAddress(natRuleDocument.getIpAddress()).port(natRuleDocument.getPort()).sourceFilter(NatRuleFilterDto.ofDocument(natRuleDocument.getSrcFilter())).destinationFilter(NatRuleFilterDto.ofDocument(natRuleDocument.getDstFilter())).logging(natRuleDocument.isLoggingEnabled()).exclude(natRuleDocument.isExcluded()).settingPreference(natRuleDocument.getSettingPreference()).ruleIndex(natRuleDocument.getRuleIndex()).isPredefined(natRuleDocument.isPredefined()).build();
    }

    default public NatRuleDocument toDocument(String string) {
        return this.documentBuilder(string).\u00d3O0000(this.id()).o00000();
    }

    default public NatRuleDocument toDocument(String string, String string2) {
        return this.documentBuilder(string2).\u00d3O0000(string).o00000();
    }

    default public G documentBuilder(String string) {
        return NatRuleDocument.builder().\u00f600000(string).\u00f800000(this.enabled()).oO0000(this.type()).for(this.description()).null(this.protocol()).\u00d200000(this.inInterface()).\u00d800000(this.outInterface()).\u00d500000(this.ipAddress()).String(this.port()).\u00d5O0000(this.sourceFilter().toDocument()).\u00f500000(this.destinationFilter().toDocument()).\u00d600000(this.logging()).\u00d2O0000(this.exclude()).\u00d300000(this.settingPreference()).\u00d6O0000(this.ruleIndex()).private(this.isPredefined());
    }
}

