/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.speedtest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OoOO.C;
import com.ubnt.ace.G;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.X;
import com.ubnt.model.api.speedtest.ImmutableSpeedtestDto;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.WanProviderCapabilityDto;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableSpeedtestDto.class)
@Value.Immutable
@C
public abstract class SpeedtestDto {
    @JsonProperty(value="id")
    public abstract Optional<String> id();

    @JsonProperty(value="download_mbps")
    public abstract long downloadMbps();

    @JsonProperty(value="upload_mbps")
    public abstract long uploadMbps();

    @JsonProperty(value="latency_ms")
    public abstract long latencyMs();

    @JsonProperty(value="time")
    public abstract Long timestamp();

    @JsonProperty(value="interface_name")
    public abstract String interfaceName();

    @JsonProperty(value="wan_networkgroup")
    public abstract Optional<WanNetworkGroup> wanNetworkGroup();

    @JsonProperty(value="network_conf_id")
    public abstract Optional<String> networkConfId();

    @JsonProperty(value="wan_provider_capabilities")
    public abstract Optional<WanProviderCapabilityDto> wanProviderCapabilities();

    public static ImmutableSpeedtestDto.Builder builder() {
        return ImmutableSpeedtestDto.builder();
    }

    public static SpeedtestDto fromX(X x2) {
        return SpeedtestDto.builder().id(Optional.ofNullable(x2.getString("_id"))).latencyMs(x2.getLong("latency")).downloadMbps(x2.getLong("xput_download")).uploadMbps(x2.getLong("xput_upload")).timestamp(x2.getLong("time")).interfaceName(x2.getString("interface_name", "")).wanNetworkGroup(WanNetworkGroup.ofStringValueOptional(x2.getString("wan_networkgroup"))).build();
    }

    public static SpeedtestDto fromX(X x2, NetworkConf networkConf) {
        return SpeedtestDto.builder().from(SpeedtestDto.fromX(x2)).networkConfId(networkConf.getId()).wanProviderCapabilities(WanProviderCapabilityDto.fromCapabilities(networkConf.getWanProviderCapabilities())).build();
    }

    public static SpeedtestDto withoutData(NetworkConf networkConf, String string) {
        return SpeedtestDto.builder().interfaceName(string).wanNetworkGroup(WanNetworkGroup.ofStringValue(networkConf.getNetworkGroup())).networkConfId(networkConf.getId()).wanProviderCapabilities(WanProviderCapabilityDto.fromCapabilities(networkConf.getWanProviderCapabilities())).build();
    }

    public String toCsvRow() {
        return G.o00000(List.of(this.timestamp(), Long.valueOf(this.latencyMs()), Long.valueOf(this.downloadMbps()), Long.valueOf(this.uploadMbps())));
    }
}

