/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.uid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.network.configuration.VpnNetworkProtocol;
import com.ubnt.model.api.uid.UidVpnServerConfigurationDto;
import com.ubnt.model.api.uid.UidVpnServerRadiusConfigurationDto;
import com.ubnt.model.api.uid.UidVpnType;
import com.ubnt.net.v2.validation.constraints.Ip;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Schema(name="UID VPN Server Configuration")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="UidVpnServerConfigurationDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableUidVpnServerConfigurationDto
extends UidVpnServerConfigurationDto {
    private final UidVpnType vpnType;
    private final boolean isEnabled;
    private final String name;
    @Nullable
    private final String networkConfId;
    @Nullable
    private final String ipSubnet;
    @Nullable
    private final String ipv6Subnet;
    private final List<String> dns;
    @Nullable
    private final String localWanIp;
    private final int serverPort;
    @Nullable
    private final Integer publicGatewayPort;
    @Nullable
    private final UidVpnServerRadiusConfigurationDto radius;
    @Nullable
    private final String caCrt;
    @Nullable
    private final String caKey;
    @Nullable
    private final String serverCrt;
    private final String serverKey;
    @Nullable
    private final String authKey;
    @Nullable
    private final String dhKey;
    private final VpnNetworkProtocol protocol;
    @Nullable
    private final Integer renegotiationTimeout;
    private final boolean isStrictClientCommonName;
    @Nullable
    private final String uidWorkspaceUrl;
    private final boolean masqueradeEnabled;
    @Nullable
    private final String uidPolicyName;
    private final boolean uidPolicyEnabled;
    private final List<String> customRouting;
    @Nullable
    private final String defaultDnsSuffix;
    private final boolean syncPublicIp;
    @Nullable
    private final Integer maxConnectionTimeSeconds;

    private ImmutableUidVpnServerConfigurationDto(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.name = builder.name;
        this.networkConfId = builder.networkConfId;
        this.ipSubnet = builder.ipSubnet;
        this.ipv6Subnet = builder.ipv6Subnet;
        this.dns = ImmutableUidVpnServerConfigurationDto.\u00d6\u00f4O000(true, builder.dns);
        this.localWanIp = builder.localWanIp;
        this.serverPort = builder.serverPort;
        this.publicGatewayPort = builder.publicGatewayPort;
        this.radius = builder.radius;
        this.caCrt = builder.caCrt;
        this.caKey = builder.caKey;
        this.serverCrt = builder.serverCrt;
        this.serverKey = builder.serverKey;
        this.authKey = builder.authKey;
        this.dhKey = builder.dhKey;
        this.protocol = builder.protocol;
        this.renegotiationTimeout = builder.renegotiationTimeout;
        this.isStrictClientCommonName = builder.isStrictClientCommonName;
        this.uidWorkspaceUrl = builder.uidWorkspaceUrl;
        this.masqueradeEnabled = builder.masqueradeEnabled;
        this.uidPolicyName = builder.uidPolicyName;
        this.uidPolicyEnabled = builder.uidPolicyEnabled;
        this.customRouting = ImmutableUidVpnServerConfigurationDto.\u00d6\u00f4O000(true, builder.customRouting);
        this.defaultDnsSuffix = builder.defaultDnsSuffix;
        this.syncPublicIp = builder.syncPublicIp;
        this.maxConnectionTimeSeconds = builder.maxConnectionTimeSeconds;
        this.vpnType = builder.o00000() ? builder.vpnType : super.getVpnType();
    }

    @Override
    @JsonProperty(value="vpn_type")
    @Schema(name="By default \"openvpn\", for backward compatibility")
    public UidVpnType getVpnType() {
        return this.vpnType;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="name")
    @NotEmpty
    @Schema(required=true)
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(example="5e6285ec05938c3d128aaa07", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(value="networkconf_id")
    @Nullable
    public String getNetworkConfId() {
        return this.networkConfId;
    }

    @Override
    @JsonProperty(value="ip_subnet")
    public Optional<String> getIpSubnet() {
        return Optional.ofNullable(this.ipSubnet);
    }

    @Override
    @JsonProperty(value="ipv6_subnet")
    public Optional<String> getIpv6Subnet() {
        return Optional.ofNullable(this.ipv6Subnet);
    }

    @Override
    @JsonProperty(value="dns")
    @Ip
    public List<String> getDns() {
        return this.dns;
    }

    @Override
    @JsonProperty(value="local_wan_ip")
    public Optional<String> getLocalWanIp() {
        return Optional.ofNullable(this.localWanIp);
    }

    @Override
    @JsonProperty(value="server_port")
    @Min(value=1L)
    @Max(value=65535L)
    public @Min(value=1L) @Max(value=65535L) int getServerPort() {
        return this.serverPort;
    }

    @Override
    @JsonProperty(value="public_gateway_port")
    @Schema(description="If VPN is behind NAT, user can set a port forward on a 3rd party gateway. In this case, the UID App may use this port to connect to the VPN")
    public Optional<Integer> publicGatewayPort() {
        return Optional.ofNullable(this.publicGatewayPort);
    }

    @Override
    @JsonProperty(value="radius")
    public Optional<UidVpnServerRadiusConfigurationDto> getRadius() {
        return Optional.ofNullable(this.radius);
    }

    @Override
    @JsonProperty(value="ca_crt")
    @Schema(name="Required only for Open VPN")
    public Optional<String> getCaCrt() {
        return Optional.ofNullable(this.caCrt);
    }

    @Override
    @JsonProperty(value="ca_key")
    @Schema(name="Required only for Open VPN")
    public Optional<String> getCaKey() {
        return Optional.ofNullable(this.caKey);
    }

    @Override
    @JsonProperty(value="server_crt")
    @Schema(name="Required only for Open VPN")
    public Optional<String> getServerCrt() {
        return Optional.ofNullable(this.serverCrt);
    }

    @Override
    @JsonProperty(value="server_key")
    @Schema(name="Server Key for OpenVPN, or Private Key of WireGuard Server")
    public String getServerKey() {
        return this.serverKey;
    }

    @Override
    @JsonProperty(value="auth_key")
    @Schema(name="Required only for Open VPN")
    public Optional<String> getAuthKey() {
        return Optional.ofNullable(this.authKey);
    }

    @Override
    @JsonProperty(value="dh_key")
    @Schema(name="Required only for Open VPN")
    public Optional<String> getDhKey() {
        return Optional.ofNullable(this.dhKey);
    }

    @Override
    @Schema(name="VPN Server protocol.")
    @JsonProperty(value="protocol")
    public VpnNetworkProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    @JsonProperty(value="renegotiation_timeout")
    @Schema(name="Renegotiate data channel key after n seconds (OpenVPN only)")
    public Optional<Integer> getRenegotiationTimeout() {
        return Optional.ofNullable(this.renegotiationTimeout);
    }

    @Override
    @JsonProperty(value="strict_client_common_name")
    @Schema(description="If true, then client certificate's common name must match client's username. Effective for the server mode only (OpenVPN only)")
    public boolean isStrictClientCommonName() {
        return this.isStrictClientCommonName;
    }

    @Override
    @JsonProperty(value="uid_workspace_url")
    public Optional<String> uidWorkspaceUrl() {
        return Optional.ofNullable(this.uidWorkspaceUrl);
    }

    @Override
    @JsonProperty(value="masquerade_enabled")
    public boolean masqueradeEnabled() {
        return this.masqueradeEnabled;
    }

    @Override
    @JsonProperty(value="uid_policy_name")
    public Optional<String> uidPolicyName() {
        return Optional.ofNullable(this.uidPolicyName);
    }

    @Override
    @JsonProperty(value="uid_policy_enabled")
    public boolean uidPolicyEnabled() {
        return this.uidPolicyEnabled;
    }

    @Override
    @JsonProperty(value="custom_routing")
    public List<String> customRouting() {
        return this.customRouting;
    }

    @Override
    @JsonProperty(value="default_dns_suffix")
    public Optional<String> defaultDnsSuffix() {
        return Optional.ofNullable(this.defaultDnsSuffix);
    }

    @Override
    @JsonProperty(value="sync_public_ip")
    public boolean syncPublicIp() {
        return this.syncPublicIp;
    }

    @Override
    @JsonProperty(value="mac_connection_time_seconds")
    public Optional<Integer> maxConnectionTimeSeconds() {
        return Optional.ofNullable(this.maxConnectionTimeSeconds);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableUidVpnServerConfigurationDto && this.Objectpublic(0, (ImmutableUidVpnServerConfigurationDto)object);
    }

    private boolean Objectpublic(int n2, ImmutableUidVpnServerConfigurationDto immutableUidVpnServerConfigurationDto) {
        return this.vpnType.equals((Object)immutableUidVpnServerConfigurationDto.vpnType) && this.isEnabled == immutableUidVpnServerConfigurationDto.isEnabled && Objects.equals(this.name, immutableUidVpnServerConfigurationDto.name) && Objects.equals(this.networkConfId, immutableUidVpnServerConfigurationDto.networkConfId) && Objects.equals(this.ipSubnet, immutableUidVpnServerConfigurationDto.ipSubnet) && Objects.equals(this.ipv6Subnet, immutableUidVpnServerConfigurationDto.ipv6Subnet) && this.dns.equals(immutableUidVpnServerConfigurationDto.dns) && Objects.equals(this.localWanIp, immutableUidVpnServerConfigurationDto.localWanIp) && this.serverPort == immutableUidVpnServerConfigurationDto.serverPort && Objects.equals(this.publicGatewayPort, immutableUidVpnServerConfigurationDto.publicGatewayPort) && Objects.equals(this.radius, immutableUidVpnServerConfigurationDto.radius) && Objects.equals(this.caCrt, immutableUidVpnServerConfigurationDto.caCrt) && Objects.equals(this.caKey, immutableUidVpnServerConfigurationDto.caKey) && Objects.equals(this.serverCrt, immutableUidVpnServerConfigurationDto.serverCrt) && Objects.equals(this.serverKey, immutableUidVpnServerConfigurationDto.serverKey) && Objects.equals(this.authKey, immutableUidVpnServerConfigurationDto.authKey) && Objects.equals(this.dhKey, immutableUidVpnServerConfigurationDto.dhKey) && Objects.equals((Object)this.protocol, (Object)immutableUidVpnServerConfigurationDto.protocol) && Objects.equals(this.renegotiationTimeout, immutableUidVpnServerConfigurationDto.renegotiationTimeout) && this.isStrictClientCommonName == immutableUidVpnServerConfigurationDto.isStrictClientCommonName && Objects.equals(this.uidWorkspaceUrl, immutableUidVpnServerConfigurationDto.uidWorkspaceUrl) && this.masqueradeEnabled == immutableUidVpnServerConfigurationDto.masqueradeEnabled && Objects.equals(this.uidPolicyName, immutableUidVpnServerConfigurationDto.uidPolicyName) && this.uidPolicyEnabled == immutableUidVpnServerConfigurationDto.uidPolicyEnabled && this.customRouting.equals(immutableUidVpnServerConfigurationDto.customRouting) && Objects.equals(this.defaultDnsSuffix, immutableUidVpnServerConfigurationDto.defaultDnsSuffix) && this.syncPublicIp == immutableUidVpnServerConfigurationDto.syncPublicIp && Objects.equals(this.maxConnectionTimeSeconds, immutableUidVpnServerConfigurationDto.maxConnectionTimeSeconds);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.vpnType.hashCode();
        n2 += (n2 << 5) + Boolean.hashCode(this.isEnabled);
        n2 += (n2 << 5) + Objects.hashCode(this.name);
        n2 += (n2 << 5) + Objects.hashCode(this.networkConfId);
        n2 += (n2 << 5) + Objects.hashCode(this.ipSubnet);
        n2 += (n2 << 5) + Objects.hashCode(this.ipv6Subnet);
        n2 += (n2 << 5) + this.dns.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.localWanIp);
        n2 += (n2 << 5) + this.serverPort;
        n2 += (n2 << 5) + Objects.hashCode(this.publicGatewayPort);
        n2 += (n2 << 5) + Objects.hashCode(this.radius);
        n2 += (n2 << 5) + Objects.hashCode(this.caCrt);
        n2 += (n2 << 5) + Objects.hashCode(this.caKey);
        n2 += (n2 << 5) + Objects.hashCode(this.serverCrt);
        n2 += (n2 << 5) + Objects.hashCode(this.serverKey);
        n2 += (n2 << 5) + Objects.hashCode(this.authKey);
        n2 += (n2 << 5) + Objects.hashCode(this.dhKey);
        n2 += (n2 << 5) + Objects.hashCode((Object)this.protocol);
        n2 += (n2 << 5) + Objects.hashCode(this.renegotiationTimeout);
        n2 += (n2 << 5) + Boolean.hashCode(this.isStrictClientCommonName);
        n2 += (n2 << 5) + Objects.hashCode(this.uidWorkspaceUrl);
        n2 += (n2 << 5) + Boolean.hashCode(this.masqueradeEnabled);
        n2 += (n2 << 5) + Objects.hashCode(this.uidPolicyName);
        n2 += (n2 << 5) + Boolean.hashCode(this.uidPolicyEnabled);
        n2 += (n2 << 5) + this.customRouting.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.defaultDnsSuffix);
        n2 += (n2 << 5) + Boolean.hashCode(this.syncPublicIp);
        n2 += (n2 << 5) + Objects.hashCode(this.maxConnectionTimeSeconds);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UidVpnServerConfigurationDto{");
        stringBuilder.append("vpnType=").append((Object)this.vpnType);
        stringBuilder.append(", ");
        stringBuilder.append("isEnabled=").append(this.isEnabled);
        if (this.name != null) {
            stringBuilder.append(", ");
            stringBuilder.append("name=").append(this.name);
        }
        if (this.networkConfId != null) {
            stringBuilder.append(", ");
            stringBuilder.append("networkConfId=").append(this.networkConfId);
        }
        if (this.ipSubnet != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipSubnet=").append(this.ipSubnet);
        }
        if (this.ipv6Subnet != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipv6Subnet=").append(this.ipv6Subnet);
        }
        stringBuilder.append(", ");
        stringBuilder.append("dns=").append(this.dns);
        if (this.localWanIp != null) {
            stringBuilder.append(", ");
            stringBuilder.append("localWanIp=").append(this.localWanIp);
        }
        stringBuilder.append(", ");
        stringBuilder.append("serverPort=").append(this.serverPort);
        if (this.publicGatewayPort != null) {
            stringBuilder.append(", ");
            stringBuilder.append("publicGatewayPort=").append(this.publicGatewayPort);
        }
        if (this.radius != null) {
            stringBuilder.append(", ");
            stringBuilder.append("radius=").append(this.radius);
        }
        if (this.caCrt != null) {
            stringBuilder.append(", ");
            stringBuilder.append("caCrt=").append(this.caCrt);
        }
        if (this.caKey != null) {
            stringBuilder.append(", ");
            stringBuilder.append("caKey=").append(this.caKey);
        }
        if (this.serverCrt != null) {
            stringBuilder.append(", ");
            stringBuilder.append("serverCrt=").append(this.serverCrt);
        }
        if (this.serverKey != null) {
            stringBuilder.append(", ");
            stringBuilder.append("serverKey=").append(this.serverKey);
        }
        if (this.authKey != null) {
            stringBuilder.append(", ");
            stringBuilder.append("authKey=").append(this.authKey);
        }
        if (this.dhKey != null) {
            stringBuilder.append(", ");
            stringBuilder.append("dhKey=").append(this.dhKey);
        }
        if (this.protocol != null) {
            stringBuilder.append(", ");
            stringBuilder.append("protocol=").append((Object)this.protocol);
        }
        if (this.renegotiationTimeout != null) {
            stringBuilder.append(", ");
            stringBuilder.append("renegotiationTimeout=").append(this.renegotiationTimeout);
        }
        stringBuilder.append(", ");
        stringBuilder.append("isStrictClientCommonName=").append(this.isStrictClientCommonName);
        if (this.uidWorkspaceUrl != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uidWorkspaceUrl=").append(this.uidWorkspaceUrl);
        }
        stringBuilder.append(", ");
        stringBuilder.append("masqueradeEnabled=").append(this.masqueradeEnabled);
        if (this.uidPolicyName != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uidPolicyName=").append(this.uidPolicyName);
        }
        stringBuilder.append(", ");
        stringBuilder.append("uidPolicyEnabled=").append(this.uidPolicyEnabled);
        stringBuilder.append(", ");
        stringBuilder.append("customRouting=").append(this.customRouting);
        if (this.defaultDnsSuffix != null) {
            stringBuilder.append(", ");
            stringBuilder.append("defaultDnsSuffix=").append(this.defaultDnsSuffix);
        }
        stringBuilder.append(", ");
        stringBuilder.append("syncPublicIp=").append(this.syncPublicIp);
        if (this.maxConnectionTimeSeconds != null) {
            stringBuilder.append(", ");
            stringBuilder.append("maxConnectionTimeSeconds=").append(this.maxConnectionTimeSeconds);
        }
        return stringBuilder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUidVpnServerConfigurationDto \u00f4\u00f4O000(_o _o2) {
        Builder builder = ImmutableUidVpnServerConfigurationDto.builder();
        if (_o2.o\u00f40000) {
            builder.vpnType(_o2.\u00d2\u00f60000);
        }
        if (_o2.Objectreturn) {
            builder.isEnabled(_o2.\u00d4\u00f60000);
        }
        if (_o2.\u00f4\u00f60000 != null) {
            builder.name(_o2.\u00f4\u00f60000);
        }
        if (_o2.\u00d6\u00f40000 != null) {
            builder.networkConfId(_o2.\u00d6\u00f40000);
        }
        if (_o2.O\u00f60000 != null) {
            builder.ipSubnet(_o2.O\u00f60000);
        }
        if (_o2.o\u00f60000 != null) {
            builder.ipv6Subnet(_o2.o\u00f60000);
        }
        if (_o2.\u00f4\u00f40000 != null) {
            builder.addAllDns(_o2.\u00f4\u00f40000);
        }
        if (_o2.\u00d5\u00f60000 != null) {
            builder.localWanIp(_o2.\u00d5\u00f60000);
        }
        if (_o2.voidreturn) {
            builder.serverPort(_o2.\u00f5\u00f50000);
        }
        if (_o2.O\u00f50000 != null) {
            builder.publicGatewayPort(_o2.O\u00f50000);
        }
        if (_o2.\u00d5\u00f40000 != null) {
            builder.radius(_o2.\u00d5\u00f40000);
        }
        if (_o2.intvoid != null) {
            builder.caCrt(_o2.intvoid);
        }
        if (_o2.classvoid != null) {
            builder.caKey(_o2.classvoid);
        }
        if (_o2.supervoid != null) {
            builder.serverCrt(_o2.supervoid);
        }
        if (_o2.\u00d5\u00f50000 != null) {
            builder.serverKey(_o2.\u00d5\u00f50000);
        }
        if (_o2.\u00d4\u00f50000 != null) {
            builder.authKey(_o2.\u00d4\u00f50000);
        }
        if (_o2.publicreturn != null) {
            builder.dhKey(_o2.publicreturn);
        }
        if (_o2.\u00d6\u00f50000 != null) {
            builder.protocol(_o2.\u00d6\u00f50000);
        }
        if (_o2.dovoid != null) {
            builder.renegotiationTimeout(_o2.dovoid);
        }
        if (_o2.\u00f4\u00f50000) {
            builder.isStrictClientCommonName(_o2.interfaceclass);
        }
        if (_o2.floatreturn != null) {
            builder.uidWorkspaceUrl(_o2.floatreturn);
        }
        if (_o2.\u00d4\u00f40000) {
            builder.masqueradeEnabled(_o2.\u00d6\u00f60000);
        }
        if (_o2.\u00f6\u00f50000 != null) {
            builder.uidPolicyName(_o2.\u00f6\u00f50000);
        }
        if (_o2.\u00d2\u00f40000) {
            builder.uidPolicyEnabled(_o2.O\u00f40000);
        }
        if (_o2.\u00f6\u00d80000 != null) {
            builder.addAllCustomRouting(_o2.\u00f6\u00d80000);
        }
        if (_o2.\u00f6\u00f40000 != null) {
            builder.defaultDnsSuffix(_o2.\u00f6\u00f40000);
        }
        if (_o2.\u00d2\u00f50000) {
            builder.syncPublicIp(_o2.\u00f5\u00f40000);
        }
        if (_o2.o\u00f50000 != null) {
            builder.maxConnectionTimeSeconds(_o2.o\u00f50000);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d8\u00f4O000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> \u00d6\u00f4O000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UidVpnServerConfigurationDto", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_VPN_TYPE = 1L;
        private long optBits;
        @Nullable
        private UidVpnType vpnType;
        private boolean isEnabled;
        @Nullable
        private String name;
        @Nullable
        private String networkConfId;
        @Nullable
        private String ipSubnet;
        @Nullable
        private String ipv6Subnet;
        private List<String> dns = new ArrayList<String>();
        @Nullable
        private String localWanIp;
        private int serverPort;
        @Nullable
        private Integer publicGatewayPort;
        @Nullable
        private UidVpnServerRadiusConfigurationDto radius;
        @Nullable
        private String caCrt;
        @Nullable
        private String caKey;
        @Nullable
        private String serverCrt;
        @Nullable
        private String serverKey;
        @Nullable
        private String authKey;
        @Nullable
        private String dhKey;
        @Nullable
        private VpnNetworkProtocol protocol;
        @Nullable
        private Integer renegotiationTimeout;
        private boolean isStrictClientCommonName;
        @Nullable
        private String uidWorkspaceUrl;
        private boolean masqueradeEnabled;
        @Nullable
        private String uidPolicyName;
        private boolean uidPolicyEnabled;
        private List<String> customRouting = new ArrayList<String>();
        @Nullable
        private String defaultDnsSuffix;
        private boolean syncPublicIp;
        @Nullable
        private Integer maxConnectionTimeSeconds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UidVpnServerConfigurationDto uidVpnServerConfigurationDto) {
            Optional<Integer> optional;
            VpnNetworkProtocol vpnNetworkProtocol;
            Optional<String> optional2;
            Optional<String> optional3;
            String string;
            Optional<String> optional4;
            Optional<String> optional5;
            Optional<String> optional6;
            Optional<UidVpnServerRadiusConfigurationDto> optional7;
            Optional<String> optional8;
            Optional<String> optional9;
            String string2;
            Objects.requireNonNull(uidVpnServerConfigurationDto, "instance");
            this.vpnType(uidVpnServerConfigurationDto.getVpnType());
            this.isEnabled(uidVpnServerConfigurationDto.isEnabled());
            String string3 = uidVpnServerConfigurationDto.getName();
            if (string3 != null) {
                this.name(string3);
            }
            if ((string2 = uidVpnServerConfigurationDto.getNetworkConfId()) != null) {
                this.networkConfId(string2);
            }
            if ((optional9 = uidVpnServerConfigurationDto.getIpSubnet()).isPresent()) {
                this.ipSubnet(optional9);
            }
            if ((optional8 = uidVpnServerConfigurationDto.getIpv6Subnet()).isPresent()) {
                this.ipv6Subnet(optional8);
            }
            this.addAllDns(uidVpnServerConfigurationDto.getDns());
            Optional<String> optional10 = uidVpnServerConfigurationDto.getLocalWanIp();
            if (optional10.isPresent()) {
                this.localWanIp(optional10);
            }
            this.serverPort(uidVpnServerConfigurationDto.getServerPort());
            Optional<Integer> optional11 = uidVpnServerConfigurationDto.publicGatewayPort();
            if (optional11.isPresent()) {
                this.publicGatewayPort(optional11);
            }
            if ((optional7 = uidVpnServerConfigurationDto.getRadius()).isPresent()) {
                this.radius(optional7);
            }
            if ((optional6 = uidVpnServerConfigurationDto.getCaCrt()).isPresent()) {
                this.caCrt(optional6);
            }
            if ((optional5 = uidVpnServerConfigurationDto.getCaKey()).isPresent()) {
                this.caKey(optional5);
            }
            if ((optional4 = uidVpnServerConfigurationDto.getServerCrt()).isPresent()) {
                this.serverCrt(optional4);
            }
            if ((string = uidVpnServerConfigurationDto.getServerKey()) != null) {
                this.serverKey(string);
            }
            if ((optional3 = uidVpnServerConfigurationDto.getAuthKey()).isPresent()) {
                this.authKey(optional3);
            }
            if ((optional2 = uidVpnServerConfigurationDto.getDhKey()).isPresent()) {
                this.dhKey(optional2);
            }
            if ((vpnNetworkProtocol = uidVpnServerConfigurationDto.getProtocol()) != null) {
                this.protocol(vpnNetworkProtocol);
            }
            if ((optional = uidVpnServerConfigurationDto.getRenegotiationTimeout()).isPresent()) {
                this.renegotiationTimeout(optional);
            }
            this.isStrictClientCommonName(uidVpnServerConfigurationDto.isStrictClientCommonName());
            Optional<String> optional12 = uidVpnServerConfigurationDto.uidWorkspaceUrl();
            if (optional12.isPresent()) {
                this.uidWorkspaceUrl(optional12);
            }
            this.masqueradeEnabled(uidVpnServerConfigurationDto.masqueradeEnabled());
            Optional<String> optional13 = uidVpnServerConfigurationDto.uidPolicyName();
            if (optional13.isPresent()) {
                this.uidPolicyName(optional13);
            }
            this.uidPolicyEnabled(uidVpnServerConfigurationDto.uidPolicyEnabled());
            this.addAllCustomRouting(uidVpnServerConfigurationDto.customRouting());
            Optional<String> optional14 = uidVpnServerConfigurationDto.defaultDnsSuffix();
            if (optional14.isPresent()) {
                this.defaultDnsSuffix(optional14);
            }
            this.syncPublicIp(uidVpnServerConfigurationDto.syncPublicIp());
            Optional<Integer> optional15 = uidVpnServerConfigurationDto.maxConnectionTimeSeconds();
            if (optional15.isPresent()) {
                this.maxConnectionTimeSeconds(optional15);
            }
            return this;
        }

        @JsonProperty(value="vpn_type")
        @CanIgnoreReturnValue
        public final Builder vpnType(UidVpnType uidVpnType) {
            this.vpnType = uidVpnType;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder isEnabled(boolean bl) {
            this.isEnabled = bl;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String string) {
            this.name = string;
            return this;
        }

        @JsonProperty(value="networkconf_id")
        @CanIgnoreReturnValue
        public final Builder networkConfId(@Nullable String string) {
            this.networkConfId = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipSubnet(@Nullable String string) {
            this.ipSubnet = string;
            return this;
        }

        @JsonProperty(value="ip_subnet")
        @CanIgnoreReturnValue
        public final Builder ipSubnet(Optional<String> optional) {
            this.ipSubnet = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipv6Subnet(@Nullable String string) {
            this.ipv6Subnet = string;
            return this;
        }

        @JsonProperty(value="ipv6_subnet")
        @CanIgnoreReturnValue
        public final Builder ipv6Subnet(Optional<String> optional) {
            this.ipv6Subnet = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDns(@Nullable String string) {
            this.dns.add(string);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDns(String ... stringArray) {
            for (String string : stringArray) {
                this.dns.add(string);
            }
            return this;
        }

        @JsonProperty(value="dns")
        @CanIgnoreReturnValue
        public final Builder dns(Iterable<String> iterable) {
            this.dns.clear();
            return this.addAllDns(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDns(Iterable<String> iterable) {
            for (String string : iterable) {
                this.dns.add(string);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localWanIp(@Nullable String string) {
            this.localWanIp = string;
            return this;
        }

        @JsonProperty(value="local_wan_ip")
        @CanIgnoreReturnValue
        public final Builder localWanIp(Optional<String> optional) {
            this.localWanIp = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="server_port")
        @CanIgnoreReturnValue
        public final Builder serverPort(int n2) {
            this.serverPort = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicGatewayPort(@Nullable Integer n2) {
            this.publicGatewayPort = n2;
            return this;
        }

        @JsonProperty(value="public_gateway_port")
        @CanIgnoreReturnValue
        public final Builder publicGatewayPort(Optional<Integer> optional) {
            this.publicGatewayPort = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder radius(@Nullable UidVpnServerRadiusConfigurationDto uidVpnServerRadiusConfigurationDto) {
            this.radius = uidVpnServerRadiusConfigurationDto;
            return this;
        }

        @JsonProperty(value="radius")
        @CanIgnoreReturnValue
        public final Builder radius(Optional<? extends UidVpnServerRadiusConfigurationDto> optional) {
            this.radius = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caCrt(@Nullable String string) {
            this.caCrt = string;
            return this;
        }

        @JsonProperty(value="ca_crt")
        @CanIgnoreReturnValue
        public final Builder caCrt(Optional<String> optional) {
            this.caCrt = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caKey(@Nullable String string) {
            this.caKey = string;
            return this;
        }

        @JsonProperty(value="ca_key")
        @CanIgnoreReturnValue
        public final Builder caKey(Optional<String> optional) {
            this.caKey = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serverCrt(@Nullable String string) {
            this.serverCrt = string;
            return this;
        }

        @JsonProperty(value="server_crt")
        @CanIgnoreReturnValue
        public final Builder serverCrt(Optional<String> optional) {
            this.serverCrt = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="server_key")
        @CanIgnoreReturnValue
        public final Builder serverKey(String string) {
            this.serverKey = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authKey(@Nullable String string) {
            this.authKey = string;
            return this;
        }

        @JsonProperty(value="auth_key")
        @CanIgnoreReturnValue
        public final Builder authKey(Optional<String> optional) {
            this.authKey = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dhKey(@Nullable String string) {
            this.dhKey = string;
            return this;
        }

        @JsonProperty(value="dh_key")
        @CanIgnoreReturnValue
        public final Builder dhKey(Optional<String> optional) {
            this.dhKey = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="protocol")
        @CanIgnoreReturnValue
        public final Builder protocol(VpnNetworkProtocol vpnNetworkProtocol) {
            this.protocol = vpnNetworkProtocol;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder renegotiationTimeout(@Nullable Integer n2) {
            this.renegotiationTimeout = n2;
            return this;
        }

        @JsonProperty(value="renegotiation_timeout")
        @CanIgnoreReturnValue
        public final Builder renegotiationTimeout(Optional<Integer> optional) {
            this.renegotiationTimeout = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="strict_client_common_name")
        @CanIgnoreReturnValue
        public final Builder isStrictClientCommonName(boolean bl) {
            this.isStrictClientCommonName = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uidWorkspaceUrl(@Nullable String string) {
            this.uidWorkspaceUrl = string;
            return this;
        }

        @JsonProperty(value="uid_workspace_url")
        @CanIgnoreReturnValue
        public final Builder uidWorkspaceUrl(Optional<String> optional) {
            this.uidWorkspaceUrl = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="masquerade_enabled")
        @CanIgnoreReturnValue
        public final Builder masqueradeEnabled(boolean bl) {
            this.masqueradeEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uidPolicyName(@Nullable String string) {
            this.uidPolicyName = string;
            return this;
        }

        @JsonProperty(value="uid_policy_name")
        @CanIgnoreReturnValue
        public final Builder uidPolicyName(Optional<String> optional) {
            this.uidPolicyName = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="uid_policy_enabled")
        @CanIgnoreReturnValue
        public final Builder uidPolicyEnabled(boolean bl) {
            this.uidPolicyEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomRouting(@Nullable String string) {
            this.customRouting.add(string);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomRouting(String ... stringArray) {
            for (String string : stringArray) {
                this.customRouting.add(string);
            }
            return this;
        }

        @JsonProperty(value="custom_routing")
        @CanIgnoreReturnValue
        public final Builder customRouting(Iterable<String> iterable) {
            this.customRouting.clear();
            return this.addAllCustomRouting(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomRouting(Iterable<String> iterable) {
            for (String string : iterable) {
                this.customRouting.add(string);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultDnsSuffix(@Nullable String string) {
            this.defaultDnsSuffix = string;
            return this;
        }

        @JsonProperty(value="default_dns_suffix")
        @CanIgnoreReturnValue
        public final Builder defaultDnsSuffix(Optional<String> optional) {
            this.defaultDnsSuffix = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="sync_public_ip")
        @CanIgnoreReturnValue
        public final Builder syncPublicIp(boolean bl) {
            this.syncPublicIp = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxConnectionTimeSeconds(@Nullable Integer n2) {
            this.maxConnectionTimeSeconds = n2;
            return this;
        }

        @JsonProperty(value="mac_connection_time_seconds")
        @CanIgnoreReturnValue
        public final Builder maxConnectionTimeSeconds(Optional<Integer> optional) {
            this.maxConnectionTimeSeconds = optional.orElse(null);
            return this;
        }

        public ImmutableUidVpnServerConfigurationDto build() {
            return new ImmutableUidVpnServerConfigurationDto(this);
        }

        private boolean o00000() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UidVpnServerConfigurationDto", generator="Immutables")
    static final class _o
    extends UidVpnServerConfigurationDto {
        @Nullable
        UidVpnType \u00d2\u00f60000;
        boolean o\u00f40000;
        boolean \u00d4\u00f60000;
        boolean Objectreturn;
        @Nullable
        String \u00f4\u00f60000;
        @Nullable
        String \u00d6\u00f40000;
        @Nullable
        Optional<String> O\u00f60000 = Optional.empty();
        @Nullable
        Optional<String> o\u00f60000 = Optional.empty();
        @Nullable
        List<String> \u00f4\u00f40000 = Collections.emptyList();
        @Nullable
        Optional<String> \u00d5\u00f60000 = Optional.empty();
        int \u00f5\u00f50000;
        boolean voidreturn;
        @Nullable
        Optional<Integer> O\u00f50000 = Optional.empty();
        @Nullable
        Optional<UidVpnServerRadiusConfigurationDto> \u00d5\u00f40000 = Optional.empty();
        @Nullable
        Optional<String> intvoid = Optional.empty();
        @Nullable
        Optional<String> classvoid = Optional.empty();
        @Nullable
        Optional<String> supervoid = Optional.empty();
        @Nullable
        String \u00d5\u00f50000;
        @Nullable
        Optional<String> \u00d4\u00f50000 = Optional.empty();
        @Nullable
        Optional<String> publicreturn = Optional.empty();
        @Nullable
        VpnNetworkProtocol \u00d6\u00f50000;
        @Nullable
        Optional<Integer> dovoid = Optional.empty();
        boolean interfaceclass;
        boolean \u00f4\u00f50000;
        @Nullable
        Optional<String> floatreturn = Optional.empty();
        boolean \u00d6\u00f60000;
        boolean \u00d4\u00f40000;
        @Nullable
        Optional<String> \u00f6\u00f50000 = Optional.empty();
        boolean O\u00f40000;
        boolean \u00d2\u00f40000;
        @Nullable
        List<String> \u00f6\u00d80000 = Collections.emptyList();
        @Nullable
        Optional<String> \u00f6\u00f40000 = Optional.empty();
        boolean \u00f5\u00f40000;
        boolean \u00d2\u00f50000;
        @Nullable
        Optional<Integer> o\u00f50000 = Optional.empty();

        _o() {
        }

        @JsonProperty(value="vpn_type")
        @Schema(name="By default \"openvpn\", for backward compatibility")
        public void dowhile(UidVpnType uidVpnType) {
            this.\u00d2\u00f60000 = uidVpnType;
            this.o\u00f40000 = null != uidVpnType;
        }

        @JsonProperty(value="enabled")
        public void \u00f6\u00d8O000(boolean bl) {
            this.\u00d4\u00f60000 = bl;
            this.Objectreturn = true;
        }

        @JsonProperty(value="name")
        @NotEmpty
        @Schema(required=true)
        public void \u00d8\u00d6O000(String string) {
            this.\u00f4\u00f60000 = string;
        }

        @Schema(example="5e6285ec05938c3d128aaa07", accessMode=Schema.AccessMode.READ_ONLY)
        @JsonProperty(value="networkconf_id")
        public void superwhile(@Nullable String string) {
            this.\u00d6\u00f40000 = string;
        }

        @JsonProperty(value="ip_subnet")
        public void \u00d3\u00f4O000(Optional<String> optional) {
            this.O\u00f60000 = optional;
        }

        @JsonProperty(value="ipv6_subnet")
        public void \u00f6\u00d6O000(Optional<String> optional) {
            this.o\u00f60000 = optional;
        }

        @JsonProperty(value="dns")
        @Ip
        public void \u00d6\u00d8O000(List<String> list) {
            this.\u00f4\u00f40000 = list;
        }

        @JsonProperty(value="local_wan_ip")
        public void \u00d6\u00d6O000(Optional<String> optional) {
            this.\u00d5\u00f60000 = optional;
        }

        @JsonProperty(value="server_port")
        @Min(value=1L)
        @Max(value=65535L)
        public void \u00f8\u00d8O000(int n2) {
            this.\u00f5\u00f50000 = n2;
            this.voidreturn = true;
        }

        @JsonProperty(value="public_gateway_port")
        @Schema(description="If VPN is behind NAT, user can set a port forward on a 3rd party gateway. In this case, the UID App may use this port to connect to the VPN")
        public void O\u00d8O000(Optional<Integer> optional) {
            this.O\u00f50000 = optional;
        }

        @JsonProperty(value="radius")
        public void O\u00f4O000(Optional<UidVpnServerRadiusConfigurationDto> optional) {
            this.\u00d5\u00f40000 = optional;
        }

        @JsonProperty(value="ca_crt")
        @Schema(name="Required only for Open VPN")
        public void interfacewhile(Optional<String> optional) {
            this.intvoid = optional;
        }

        @JsonProperty(value="ca_key")
        @Schema(name="Required only for Open VPN")
        public void \u00d8\u00d8O000(Optional<String> optional) {
            this.classvoid = optional;
        }

        @JsonProperty(value="server_crt")
        @Schema(name="Required only for Open VPN")
        public void publicdo(Optional<String> optional) {
            this.supervoid = optional;
        }

        @JsonProperty(value="server_key")
        @Schema(name="Server Key for OpenVPN, or Private Key of WireGuard Server")
        public void \u00d3\u00d6O000(String string) {
            this.\u00d5\u00f50000 = string;
        }

        @JsonProperty(value="auth_key")
        @Schema(name="Required only for Open VPN")
        public void \u00d4\u00d6O000(Optional<String> optional) {
            this.\u00d4\u00f50000 = optional;
        }

        @JsonProperty(value="dh_key")
        @Schema(name="Required only for Open VPN")
        public void \u00f4\u00d6O000(Optional<String> optional) {
            this.publicreturn = optional;
        }

        @Schema(name="VPN Server protocol.")
        @JsonProperty(value="protocol")
        public void \u00d4\u00d8O000(VpnNetworkProtocol vpnNetworkProtocol) {
            this.\u00d6\u00f50000 = vpnNetworkProtocol;
        }

        @JsonProperty(value="renegotiation_timeout")
        @Schema(name="Renegotiate data channel key after n seconds (OpenVPN only)")
        public void \u00d2\u00f4O000(Optional<Integer> optional) {
            this.dovoid = optional;
        }

        @JsonProperty(value="strict_client_common_name")
        @Schema(description="If true, then client certificate's common name must match client's username. Effective for the server mode only (OpenVPN only)")
        public void classwhile(boolean bl) {
            this.interfaceclass = bl;
            this.\u00f4\u00f50000 = true;
        }

        @JsonProperty(value="uid_workspace_url")
        public void \u00d2\u00d6O000(Optional<String> optional) {
            this.floatreturn = optional;
        }

        @JsonProperty(value="masquerade_enabled")
        public void \u00f8\u00d6O000(boolean bl) {
            this.\u00d6\u00f60000 = bl;
            this.\u00d4\u00f40000 = true;
        }

        @JsonProperty(value="uid_policy_name")
        public void \u00d2\u00d8O000(Optional<String> optional) {
            this.\u00f6\u00f50000 = optional;
        }

        @JsonProperty(value="uid_policy_enabled")
        public void \u00d4\u00f4O000(boolean bl) {
            this.O\u00f40000 = bl;
            this.\u00d2\u00f40000 = true;
        }

        @JsonProperty(value="custom_routing")
        public void \u00d3\u00d8O000(List<String> list) {
            this.\u00f6\u00d80000 = list;
        }

        @JsonProperty(value="default_dns_suffix")
        public void intwhile(Optional<String> optional) {
            this.\u00f6\u00f40000 = optional;
        }

        @JsonProperty(value="sync_public_ip")
        public void floatdo(boolean bl) {
            this.\u00f5\u00f40000 = bl;
            this.\u00d2\u00f50000 = true;
        }

        @JsonProperty(value="mac_connection_time_seconds")
        public void \u00f4\u00d8O000(Optional<Integer> optional) {
            this.o\u00f50000 = optional;
        }

        @Override
        public UidVpnType getVpnType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNetworkConfId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIpSubnet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIpv6Subnet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLocalWanIp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServerPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> publicGatewayPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UidVpnServerRadiusConfigurationDto> getRadius() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCaCrt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCaKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServerCrt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServerKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAuthKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDhKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VpnNetworkProtocol getProtocol() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getRenegotiationTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStrictClientCommonName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> uidWorkspaceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean masqueradeEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> uidPolicyName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean uidPolicyEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> customRouting() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> defaultDnsSuffix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean syncPublicIp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> maxConnectionTimeSeconds() {
            throw new UnsupportedOperationException();
        }
    }
}

