/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.utilization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OoOO.OoOO;
import com.ubnt.model.api.utilization.ImmutableIspUtilizationDto;
import com.ubnt.model.api.utilization.WanUtilizationDto;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.service.utilization.B;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableIspUtilizationDto.class)
@Schema(name="ISP utilization")
@OoOO
@Value.Immutable
public interface IspUtilizationDto {
    @JsonProperty(value="wan_utilization_up")
    public List<WanUtilizationDto> wanUp();

    @JsonProperty(value="wan_utilization_down")
    public List<WanUtilizationDto> wanDown();

    @JsonProperty(value="wan2_utilization_up")
    public List<WanUtilizationDto> wan2Up();

    @JsonProperty(value="wan2_utilization_down")
    public List<WanUtilizationDto> wan2Down();

    @JsonProperty(value="wan_peak_transmitted_bytes_rate")
    public long wanPeakUp();

    @JsonProperty(value="wan_peak_received_bytes_rate")
    public long wanPeakDown();

    @JsonProperty(value="wan2_peak_transmitted_bytes_rate")
    public long wan2PeakUp();

    @JsonProperty(value="wan2_peak_received_bytes_rate")
    public long wan2PeakDown();

    public static ImmutableIspUtilizationDto.Builder builder() {
        return ImmutableIspUtilizationDto.builder();
    }

    public static IspUtilizationDto fromUtilizationInfo(Map<WanNetworkGroup, B> map) {
        B b2 = map.get(WanNetworkGroup.WAN);
        B b3 = map.get(WanNetworkGroup.WAN2);
        return IspUtilizationDto.builder().wanDown(b2.\u00d400000().stream().map(WanUtilizationDto::fromUtilizationInfo).toList()).wanUp(b2.\u00d200000().stream().map(WanUtilizationDto::fromUtilizationInfo).toList()).wan2Down(b3.\u00d400000().stream().map(WanUtilizationDto::fromUtilizationInfo).toList()).wan2Up(b3.\u00d200000().stream().map(WanUtilizationDto::fromUtilizationInfo).toList()).wanPeakUp(b2.o00000()).wanPeakDown(b2.\u00d500000()).wan2PeakUp(b3.o00000()).wan2PeakDown(b3.\u00d500000()).build();
    }

    public static IspUtilizationDto empty() {
        return IspUtilizationDto.builder().wanDown(Collections.emptyList()).wanUp(Collections.emptyList()).wan2Down(Collections.emptyList()).wan2Up(Collections.emptyList()).wanPeakUp(0L).wanPeakDown(0L).wan2PeakUp(0L).wan2PeakDown(0L).build();
    }
}

