/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.F.void;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Wlan Pre-Shared-Key Entry", description="associates a pre-shared key with a station identifier set and possibly a VLAN")
public class WlanPskEntry {
    @JsonProperty(value="psk")
    @NotEmpty
    @Schema(required=true, name="pre-shared-key for station")
    private String wpaPreSharedKey;
    @JsonProperty(value="mac")
    @MacAddress
    @Schema(example="aa:bb:cc:dd:ee:ff")
    private String stationMac;
    @JsonProperty(value="vlan")
    @Min(value=2L)
    @Max(value=4009L)
    @Schema(name="optional VLAN ID between 2 and 4009", example="21")
    private @Min(value=2L) @Max(value=4009L) Integer stationVlan;
    @JsonProperty(value="id")
    @Schema(name="Station ID")
    private String stationId;

    public String getWpaPreSharedKey() {
        return this.wpaPreSharedKey;
    }

    public WlanPskEntry setWpaPreSharedKey(String string) {
        this.wpaPreSharedKey = string;
        return this;
    }

    public Optional<String> getStationMac() {
        return Optional.ofNullable(this.stationMac);
    }

    public WlanPskEntry setStationMac(String string) {
        this.stationMac = string;
        return this;
    }

    public Optional<Integer> getStationVlan() {
        return Optional.ofNullable(this.stationVlan);
    }

    public WlanPskEntry setStationVlan(Integer n2) {
        this.stationVlan = n2;
        return this;
    }

    public Optional<String> getStationId() {
        return Optional.ofNullable(this.stationId);
    }

    public WlanPskEntry setStationId(String string) {
        this.stationId = string;
        return this;
    }

    public static WlanPskEntry fromLegacy(X x2) {
        return WlanPskEntry.o00000().\u00f600000(x2);
    }

    public X toLegacy() {
        return WlanPskEntry.o00000().\u00f500000(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("psk", (Object)this.wpaPreSharedKey).append("mac", (Object)this.stationMac).append("vlan", (Object)this.stationVlan).append("id", (Object)this.stationId).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WlanPskEntry wlanPskEntry = (WlanPskEntry)object;
        return this.wpaPreSharedKey.equals(wlanPskEntry.wpaPreSharedKey) && this.stationMac.equals(wlanPskEntry.stationMac) && Objects.equals(this.stationVlan, wlanPskEntry.stationVlan) && Objects.equals(this.stationId, wlanPskEntry.stationId);
    }

    public int hashCode() {
        return Objects.hash(this.stationMac, this.stationId);
    }

    private static void<WlanPskEntry, X> o00000() {
        return void.\u00d200000(WlanPskEntry.class, X.class).\u00d6O0000("psk", WlanPskEntry::getWpaPreSharedKey, WlanPskEntry::setWpaPreSharedKey).\u00d2O0000("mac", WlanPskEntry::getStationMac, WlanPskEntry::setStationMac).\u00d200000("vlan", WlanPskEntry::getStationVlan, WlanPskEntry::setStationVlan).\u00d2O0000("id", WlanPskEntry::getStationId, WlanPskEntry::setStationId).\u00f600000();
    }
}

