/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.clients;

import com.ubnt.data.Site;
import com.ubnt.model.api.ClientCount;
import com.ubnt.model.api.HistoricalActivityResponse;
import com.ubnt.model.api.HistoricalSatisfactionDto;
import com.ubnt.model.api.HistoricalScoreResponse;
import com.ubnt.model.api.TrafficInsightsOverviewDto;
import com.ubnt.model.api.TrafficInsightsResponse;
import com.ubnt.model.api.client.ClientApStatisticDto;
import com.ubnt.model.api.client.ClientApStatisticsResponseDto;
import com.ubnt.model.api.client.ClientTrafficControlDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.service.client.floatsuper;
import com.ubnt.service.client.privatesuper;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Client Statistics")
public class ClientStatisticsController {
    private final floatsuper new;
    private final privatesuper o00000;
    private final Clock \u00d300000;

    public ClientStatisticsController(floatsuper floatsuper2, privatesuper privatesuper2, Clock clock) {
        this.new = floatsuper2;
        this.o00000 = privatesuper2;
        this.\u00d300000 = clock;
    }

    @GetMapping(value={"/api/site/{siteName}/client/stats/fingerprint-os"})
    @ResponseStatus(value=HttpStatus.OK)
    public ClientCount getClientCount(@PathVariable(value="siteName") Site site, @RequestParam(value="start", required=false) Long l2, @RequestParam(value="end", required=false) Long l3) {
        return this.new.\u00d600000(site.getId(), l2, l3);
    }

    @AllowPrivilege(value={"hotspot"})
    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/24hr-satisfaction"})
    public HistoricalScoreResponse<HistoricalSatisfactionDto> getLast24HrSatisfactionScores(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        return HistoricalScoreResponse.of(this.new.oO0000(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/24hr-activity"})
    public HistoricalActivityResponse getLast24HrActivity(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        return HistoricalActivityResponse.of(this.new.\u00f5O0000(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/ap-stats"})
    public ClientApStatisticsResponseDto getClientApStatistics(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string, @RequestParam(value="start", required=false) @Parameter(schema=@Schema(defaultValue="Last 24 hours")) Long l2) {
        Instant instant = this.\u00d300000.instant();
        long l3 = Optional.ofNullable(l2).orElseGet(() -> instant.minus(Duration.ofHours(24L)).toEpochMilli());
        return ClientApStatisticsResponseDto.of(this.new.\u00f5\u00d20000(site.getId(), string, l3, instant.toEpochMilli()).stream().map(e2 -> ClientApStatisticDto.builder().deviceMac(e2.String()).deviceName(e2.\u00d200000()).sessionTimeSeconds(e2.\u00d300000()).build()).toList());
    }

    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/traffic-insights"})
    public TrafficInsightsResponse getTrafficInsights(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") String string) {
        TrafficInsightsOverviewDto trafficInsightsOverviewDto = this.new.newsuper(site.getId(), string);
        return TrafficInsightsResponse.of(trafficInsightsOverviewDto);
    }

    @GetMapping(value={"/api/site/{siteName}/clients/traffic-control"})
    public ClientTrafficControlDto getTrafficControl(@PathVariable(value="siteName") Site site) {
        return ClientTrafficControlDto.of(this.o00000.o00000(site.getId()));
    }
}

