/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewallzone;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.policy.FirewallPolicyDto;
import com.ubnt.model.api.firewallzone.FirewallMatrixSourceZoneDto;
import com.ubnt.model.api.firewallzone.FirewallZoneDto;
import com.ubnt.model.api.firewallzone.FirewallZoneRequestDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.firewall.FirewallPolicyController;
import com.ubnt.service.firewallzone.OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.service.firewallzone.oOOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Firewall zone")
public class FirewallZoneController {
    private final oOOO super;
    private final FirewallPolicyController \u00d200000;

    public FirewallZoneController(oOOO oOOO2, FirewallPolicyController firewallPolicyController) {
        this.super = oOOO2;
        this.\u00d200000 = firewallPolicyController;
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone"})
    @Operation(summary="List Firewall Zones")
    public List<FirewallZoneDto> listFirewallZones(@PathVariable(value="siteName") Site site) {
        return this.super.OO0000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone/defaults"})
    @Operation(summary="List Firewall Zone defaults")
    public List<FirewallZoneDto> listFirewallZoneDefaults(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d3o0000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/firewall/zone"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create Firewall Zone")
    public FirewallZoneDto createFirewallZone(@PathVariable(value="siteName") Site site, @RequestBody @Valid FirewallZoneRequestDto firewallZoneRequestDto) {
        return FirewallZoneDto.from(this.super.nullsuper(firewallZoneRequestDto, site.getId()), firewallZoneRequestDto.networkIds());
    }

    @PutMapping(value={"/api/site/{siteName}/firewall/zone/{zoneId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update Firewall Zone")
    public FirewallZoneDto updateFirewallZone(@PathVariable(value="siteName") Site site, @PathVariable(value="zoneId") String string, @Valid @RequestBody FirewallZoneRequestDto firewallZoneRequestDto) {
        return FirewallZoneDto.from(this.super.\u00d8O0000(firewallZoneRequestDto, site.getId()), firewallZoneRequestDto.networkIds());
    }

    @DeleteMapping(value={"/api/site/{siteName}/firewall/zone/{zoneId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete Firewall Zone")
    public void deleteFirewallZone(@PathVariable(value="siteName") Site site, @PathVariable(value="zoneId") String string) {
        this.super.forsuper(string, site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/firewall/zone/batch-delete"})
    @Operation(summary="Batch delete Firewall Zone")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void batchDeleteFirewallZones(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.super.\u00d8o0000(list, site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone-matrix"})
    @Operation(summary="Returns firewall zone matrix")
    public List<FirewallMatrixSourceZoneDto> getFirewallZoneMatrix(@PathVariable(value="siteName") Site site) {
        Map<Pair, List<FirewallPolicyDto>> map = this.\u00d200000.listFirewallPolicies(site).stream().collect(Collectors.groupingBy(firewallPolicyDto -> Pair.of((Object)firewallPolicyDto.source().zoneId(), (Object)firewallPolicyDto.destination().zoneId())));
        List<OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO> list = this.super.new(site.getId());
        return list.stream().map(ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2 -> FirewallMatrixSourceZoneDto.getFirewallMatrixSourceZoneDto(map, list, ooOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2)).toList();
    }
}

