/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.inspectionlogs;

import com.ubnt.data.Site;
import com.ubnt.model.C;
import com.ubnt.model.api.inspection.ImmutableInspectionLogsListDto;
import com.ubnt.model.api.inspection.InspectionLogBlockRequestDto;
import com.ubnt.model.api.inspection.InspectionLogBlockRulesDto;
import com.ubnt.model.api.inspection.InspectionLogDto;
import com.ubnt.model.api.inspection.InspectionLogExportParameterDto;
import com.ubnt.model.api.inspection.InspectionLogListParameterDto;
import com.ubnt.model.api.inspection.InspectionLogsListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.net.v2.inspectionlogs.exception.ErrorExportingInspectionLogs;
import com.ubnt.service.inspectionlogs.super;
import com.ubnt.service.system.oA;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.core.publisher.Flux;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Inspection Logs")
public class InspectionLogsController {
    public static final Duration INSPECTION_LOGS_EXPORT_TIMEOUT = Duration.ofHours(1L);
    private static final Logger super = oA.Stringsuper;
    private final super \u00d200000;

    public InspectionLogsController(super super_) {
        this.\u00d200000 = super_;
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/inspection-logs"})
    @Operation(summary="List Inspection Logs", description="8.2.52")
    public InspectionLogsListDto listInspectionLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid InspectionLogListParameterDto inspectionLogListParameterDto) {
        Optional<Boolean> optional;
        Page<InspectionLogDto> page = this.\u00d200000.oO0000(site.getId(), inspectionLogListParameterDto.toInspectionLogParameters());
        long l2 = page.getTotalElements();
        ImmutableInspectionLogsListDto.Builder builder = InspectionLogsListDto.builder().data((Iterable<? extends InspectionLogDto>)page).pageNumber(page.getNumber()).totalElementCount(l2).totalPageCount(page.getTotalPages());
        if (page instanceof C) {
            C c2 = (C)page;
            optional = Optional.of(c2.o00000());
        } else {
            optional = Optional.empty();
        }
        return builder.orMore(optional).hasNext(page.hasNext()).build();
    }

    @PostMapping(value={"/api/site/{siteName}/inspection-logs/export"}, consumes={"application/json"}, produces={"text/csv"})
    @AllowReadPrivileges
    @Operation(summary="Export inspection logs in CSV format", description="8.3.28")
    public ResponseEntity<StreamingResponseBody> exportInspectionLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid InspectionLogExportParameterDto inspectionLogExportParameterDto) {
        Flux<String> flux = this.\u00d200000.\u00d2O0000(site.getId(), inspectionLogExportParameterDto.toInspectionLogParameters());
        StreamingResponseBody streamingResponseBody = outputStream -> flux.subscribe(string -> {
            try {
                outputStream.write((string + "\n").getBytes());
                outputStream.flush();
            }
            catch (Exception exception) {
                throw new ErrorExportingInspectionLogs(exception);
            }
        }, throwable -> super.error("Error exporting Inspection Logs", throwable));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/csv"})).body((Object)streamingResponseBody);
    }

    @PostMapping(value={"/api/site/{siteName}/inspection-logs/block/{inspectionLogId}"})
    @Operation(summary="Block Inspection Log", description="8.3.22")
    public InspectionLogBlockRulesDto blockInspectionLog(@PathVariable(value="siteName") Site site, @PathVariable(value="inspectionLogId") String string, @RequestBody @Valid InspectionLogBlockRequestDto inspectionLogBlockRequestDto) {
        return InspectionLogBlockRulesDto.of(this.\u00d200000.OO0000(site.getId(), string, inspectionLogBlockRequestDto.toInspectionLogBlockRequest()));
    }

    @GetMapping(value={"/api/site/{siteName}/inspection-logs/block/{inspectionLogId}"})
    @Operation(summary="List Inspection Log Block Rules", description="8.3.22")
    public InspectionLogBlockRulesDto listInspectionLogBlockRules(@PathVariable(value="siteName") Site site, @PathVariable(value="inspectionLogId") String string) {
        return InspectionLogBlockRulesDto.of(this.\u00d200000.\u00f4O0000(site.getId(), string));
    }

    @AllowReadPrivileges
    @GetMapping(value={"/api/site/{siteName}/inspection-logs/threats/{threatLogId}"})
    @Operation(summary="Get Threat Log By Id")
    public InspectionLogDto getThreatLogById(@PathVariable(value="siteName") Site site, @PathVariable(value="threatLogId") String string) {
        return this.\u00d200000.\u00f400000(site.getId(), string);
    }
}

