/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.mclag;

import com.ubnt.data.Site;
import com.ubnt.model.api.mclag.McLagGroupDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.mclag.D;
import com.ubnt.service.mclag.McLagGroupDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="MC-LAG Groups")
public class McLagGroupController {
    private final D o00000;

    public McLagGroupController(D d2) {
        this.o00000 = d2;
    }

    @GetMapping(value={"/api/site/{siteName}/mclag-groups"})
    @Operation(summary="List MC-LAG Groups")
    public List<McLagGroupDto> listMcLagGroups(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00d300000(site.getId()).stream().map(McLagGroupDto::fromDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/mclag-groups"}, consumes={"application/json"})
    @Operation(summary="Create a new MC-LAG Group")
    @ResponseStatus(value=HttpStatus.CREATED)
    public McLagGroupDto createMcLagGroup(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull McLagGroupDto mcLagGroupDto) {
        McLagGroupDocument mcLagGroupDocument = this.o00000.while(mcLagGroupDto.toSortedDocument(site.getId()));
        return McLagGroupDto.fromDocument(mcLagGroupDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/mclag-groups/{mclagGroupId}"}, consumes={"application/json"})
    @Operation(summary="Update MC-LAG Group")
    public McLagGroupDto updateMcLagGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="mclagGroupId") String string, @RequestBody @Valid @NotNull McLagGroupDto mcLagGroupDto) {
        McLagGroupDto mcLagGroupDto2 = McLagGroupDto.withId(mcLagGroupDto, string);
        McLagGroupDocument mcLagGroupDocument = this.o00000.\u00f400000(mcLagGroupDto2.toSortedDocument(site.getId()));
        return McLagGroupDto.fromDocument(mcLagGroupDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/mclag-groups/{mclagGroupId}"})
    @Operation(summary="Delete MC-LAG Group")
    public void deleteMcLagGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="mclagGroupId") String string) {
        this.o00000.\u00d3O0000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/mclag-groups/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete MC-LAG Groups in Batch")
    public void deleteMcLagGroups(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull List<String> list) {
        this.o00000.o00000(site.getId(), list);
    }
}

