/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.pcap;

import com.ubnt.data.Site;
import com.ubnt.model.api.pcap.PacketCaptureStartRequestDto;
import com.ubnt.model.api.pcap.PacketCaptureStatus;
import com.ubnt.net.H.super;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowApiToken;
import com.ubnt.service.device.pcap.M;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Packet Capture")
public class PacketCaptureController {
    private final M super;

    public PacketCaptureController(M m2) {
        this.super = m2;
    }

    @PostMapping(value={"/api/site/{siteName}/pcap-start"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Run packet capture on the device")
    public void startCapture(@PathVariable(value="siteName") @Schema(description="Site Name") Site site, @RequestBody @Valid @NotNull PacketCaptureStartRequestDto packetCaptureStartRequestDto) {
        this.super.intsuper(packetCaptureStartRequestDto, site.getName());
    }

    @PostMapping(value={"/api/site/{siteName}/pcap-stop/{mac}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Stop packet capture on the device")
    public void stopCapture(@PathVariable(value="siteName") @Schema(description="Site Name") Site site, @PathVariable(value="mac") @Schema(description="MAC address of the capturing device", example="00:11:22:33:44:55") String string) {
        this.super.\u00d4o0000(string);
    }

    @PostMapping(value={"/api/site/{siteName}/pcap-upload/{mac}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Upload packet capture file to the NETWORK server")
    @AllowApiToken
    public void uploadCapture(@PathVariable(value="siteName") @Schema(description="Site Name") Site site, @PathVariable(value="mac") @Schema(description="MAC address of the captured device", example="00:11:22:33:44:55") String string, @RequestParam(value="file") @Schema(description="Result of Packet Capture") MultipartFile multipartFile) {
        this.super.\u00d5O0000(string, multipartFile);
    }

    @GetMapping(value={"/api/site/{siteName}/pcap-get/{mac}"})
    @Operation(summary="Download packet capture file")
    public ResponseEntity<Resource> getCapture(@PathVariable(value="siteName") @Schema(description="Site Name") Site site, @PathVariable(value="mac") @Schema(description="MAC address of the captured device", example="00:11:22:33:44:55") String string) throws IOException {
        Resource resource = this.super.oo0000(string);
        String string2 = com.ubnt.net.H.super.\u00d2O0000(string, false, "-").concat(".tar");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + string2})).contentType(MediaType.parseMediaType((String)"application/x-tar")).contentLength(resource.contentLength()).body((Object)resource);
    }

    @GetMapping(value={"/api/site/{siteName}/pcap-status/{mac}"})
    @Operation(summary="Get packet capture status")
    public PacketCaptureStatus getCaptureStatus(@PathVariable(value="siteName") @Schema(description="Site Name") Site site, @PathVariable(value="mac") @Schema(description="MAC address of the captured device", example="00:11:22:33:44:55") String string) {
        return this.super.Oo0000(string);
    }
}

