/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.shadowmode;

import com.ubnt.data.Site;
import com.ubnt.model.api.shadowmode.ManagedShadowModeStatusDto;
import com.ubnt.model.api.shadowmode.ShadowModeOverrideDto;
import com.ubnt.model.api.shadowmode.ShadowModeStatusDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.service.managedshadowmode.O0OO;
import com.ubnt.service.shadowmode.C;
import com.ubnt.service.shadowmode.D;
import com.ubnt.service.shadowmode.super;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Console Shadow Mode")
public class ShadowModeController {
    private final C o00000;
    private final O0OO \u00d200000;

    public ShadowModeController(C c2, O0OO o0OO2) {
        this.o00000 = c2;
        this.\u00d200000 = o0OO2;
    }

    @RequireUCoreLocal
    @GetMapping(value={"/api/site/{siteName}/shadowmode/status"})
    @Operation(summary="Get shadow mode status", description="Since 8.1.105")
    public ShadowModeStatusDto getShadowModeStatus(@PathVariable(value="siteName") Site site) {
        super super_ = this.o00000.null(site.getId());
        return ShadowModeStatusDto.builder().shadowModeConfigCreated(super_.o00000()).state(super_.\u00d200000()).build();
    }

    @RequireUCoreLocal
    @PostMapping(value={"/api/site/{siteName}/shadowmode/override"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Set shadow mode overrides", description="Since 8.1.105")
    public void overrideSettings(@PathVariable(value="siteName") Site site, @RequestBody @Valid ShadowModeOverrideDto shadowModeOverrideDto) {
        this.o00000.\u00f500000(site, D.\u00d400000(shadowModeOverrideDto));
    }

    @RequireUCoreLocal
    @PostMapping(value={"/api/site/{siteName}/shadowmode/rollback"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Initiate shadow mode rollback", description="Since 8.1.112")
    public void rollback(@PathVariable(value="siteName") Site site) {
        this.o00000.oO0000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/shadowmode/managed/group"})
    public ManagedShadowModeStatusDto getGroup(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00d500000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/shadowmode/managed/check-vrrp"})
    public boolean checkCanFinishSetup(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00d8o0000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/shadowmode/managed/begin-adoption"})
    public ManagedShadowModeStatusDto beginAdoption(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00d3O0000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/shadowmode/managed/complete-adoption"})
    public ManagedShadowModeStatusDto completeAdoption(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00d5O0000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/shadowmode/managed/rollback"})
    public ManagedShadowModeStatusDto rollbackManaged(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.\u00f6O0000(site.getId());
    }
}

