/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.sso;

import com.ubnt.ace.B;
import com.ubnt.model.api.sso.MfaPushResponseDto;
import com.ubnt.model.api.sso.MfaRequestDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPublic;
import com.ubnt.service.sso.A.o0OO;
import com.ubnt.service.sso.B.F;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="Multi-Factor Authentication")
public class MultiFactorAuthenticationController {
    private final com.ubnt.service.sso.B o00000;

    public MultiFactorAuthenticationController(com.ubnt.service.sso.B b2) {
        this.o00000 = b2;
    }

    @AllowPublic
    @PostMapping(value={"/api/mfa/email/{id}/send"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Send MFA Email", description="Since 7.0.7")
    public void sendMfaEmail(@PathVariable(value="id") String string, @CookieValue(value="UBIC_2FA", required=false) String string2, @RequestHeader(value="User-Agent", required=false) String string3, @RequestBody(required=false) MfaRequestDto mfaRequestDto) {
        this.\u00d200000(mfaRequestDto, string2);
        this.o00000.\u00d300000(o0OO.\u00d300000, string, this.o00000(mfaRequestDto, string2), string3);
    }

    @AllowPublic
    @PostMapping(value={"/api/mfa/push/{id}/send"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Send MFA Push", description="Since 7.0.7")
    public MfaPushResponseDto sendMfaPush(@PathVariable(value="id") String string2, @CookieValue(value="UBIC_2FA", required=false) String string3, @RequestHeader(value="User-Agent", required=false) String string4, @RequestBody(required=false) MfaRequestDto mfaRequestDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.\u00d200000(mfaRequestDto, string3);
        return this.o00000.\u00d300000(o0OO.return, string2, this.o00000(mfaRequestDto, string3), string4).map(string -> {
            B.intnew(httpServletRequest, httpServletResponse, "UBIC_2FA", string);
            return MfaPushResponseDto.of(string);
        }).orElse(MfaPushResponseDto.EMPTY);
    }

    @AllowPublic
    @PostMapping(value={"/api/mfa/sms/{id}/send"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Send MFA SMS", description="Since 7.0.7")
    public void sendMfaSms(@PathVariable(value="id") String string, @CookieValue(value="UBIC_2FA", required=false) String string2, @RequestHeader(value="User-Agent", required=false) String string3, @RequestBody(required=false) MfaRequestDto mfaRequestDto) {
        this.\u00d200000(mfaRequestDto, string2);
        this.o00000.\u00d300000(o0OO.\u00d800000, string, this.o00000(mfaRequestDto, string2), string3);
    }

    private void \u00d200000(MfaRequestDto mfaRequestDto, String string) {
        if (StringUtils.isEmpty((CharSequence)string) && (mfaRequestDto == null || !mfaRequestDto.mfaCookie().isPresent())) {
            throw new F();
        }
    }

    private String o00000(MfaRequestDto mfaRequestDto, String string) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            return string;
        }
        return Optional.ofNullable(mfaRequestDto).flatMap(MfaRequestDto::mfaCookie).orElse("");
    }
}

