/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.switchacl;

import com.ubnt.data.Device;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.switchacl.AclEntryCount;
import com.ubnt.model.api.switchacl.AclRuleDto;
import com.ubnt.model.api.switchacl.BatchAclRuleUpdatePartDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.devmgr.doreturn;
import com.ubnt.service.setting.K.new;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.S;
import com.ubnt.service.switchacl.oO0O;
import com.ubnt.service.switchacl.ooOO;
import com.ubnt.service.system.setting.M;
import com.ubnt.service.system.setting.null;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Switch ACL Rules")
public class AclRuleController {
    private final oO0O super;
    private final S \u00d200000;
    private final doreturn class;
    private final new \u00d300000;
    private final M \u00d400000;

    public AclRuleController(oO0O oO0O2, S s2, doreturn doreturn2, new new_, M m2) {
        this.super = oO0O2;
        this.\u00d200000 = s2;
        this.class = doreturn2;
        this.\u00d300000 = new_;
        this.\u00d400000 = m2;
    }

    @GetMapping(value={"/api/site/{siteName}/{mac}/acl-entry-count"})
    @Operation(summary="ACL Entry Count")
    public AclEntryCount getAclEntryCount(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        if (!this.class.\u00f5\u00d30O00(string2, string, Device::supportsSwitchAccessControlList)) {
            return AclEntryCount.empty();
        }
        Setting setting = this.\u00d400000.\u00d300000(null.\u00f4O0000, string2);
        int n2 = this.\u00d300000.\u00d300000(string2, setting);
        int n3 = this.\u00d200000.\u00d500000(string2, string);
        return AclEntryCount.builder().globalAclEntryCount(n2).customIpAclEntryCount(n3).customMacAclEntryCount(0).build();
    }

    @GetMapping(value={"/api/site/{siteName}/acl-rules"})
    @Operation(summary="List ACL Rules")
    public List<AclRuleDto> listAclRules(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d500000(site.getId()).stream().map(AclRuleDto::fromDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new ACL Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AclRuleDto createAclRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument = this.super.\u00d800000(aclRuleDto.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update ACL Rule")
    public AclRuleDto updateAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDto aclRuleDto2 = AclRuleDto.withId(aclRuleDto, string);
        AclRuleDocument aclRuleDocument = this.super.o00000(aclRuleDto2.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Update Selected Properties of ACL Rules in Batch")
    public List<AclRuleDto> batchUpdateAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchAclRuleUpdatePartDto> list) {
        List<ooOO> list2 = list.stream().map(BatchAclRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.super.return(site.getId(), list2).stream().map(AclRuleDto::fromDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"})
    @Operation(summary="Delete ACL Rule")
    public void deleteAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.super.\u00d400000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete ACL Rules in Batch")
    public void deleteAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<String> list) {
        this.super.\u00d300000(site.getId(), list);
    }
}

