/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifi;

import com.ubnt.data.Site;
import com.ubnt.model.api.wifi.ap.WifiApStatisticsDto;
import com.ubnt.model.api.wifi.client.WifiClientStatisticsDto;
import com.ubnt.model.api.wifi.radio.WifiChannelizationStatisticsDto;
import com.ubnt.model.api.wifi.radio.WifiRadioStatisticsDto;
import com.ubnt.net.v2.ApiFilterUtils;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.wifi.Object.B;
import com.ubnt.service.wifi.Object.F;
import com.ubnt.service.wifi.Object.if;
import com.ubnt.service.wifi.Object.oOOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Min;
import java.time.Clock;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="WiFi Statistics")
public class WifiStatisticsController {
    static final String Object = "7.1.5";
    static final String o00000 = "7.3.11";
    private final Clock \u00d200000;
    private final B \u00d600000;
    private final F \u00d400000;
    private final oOOO \u00d500000;

    public WifiStatisticsController(Clock clock, B b2, F f2, oOOO oOOO2) {
        this.\u00d200000 = clock;
        this.\u00d600000 = b2;
        this.\u00d400000 = f2;
        this.\u00d500000 = oOOO2;
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/details"})
    @Operation(summary="WiFi Client statistics", description="Since 7.1")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiClientStatisticsDto wifiClientStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="apMac", required=false) @MacAddress(allowAll=true) @MacAddress(allowAll=true) String string, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @Parameter(name="Size of top user list returned") @Min(value=1L) Integer n2) {
        if if_ = if.\u00f400000().\u00d800000(site.getId()).\u00d300000(com.ubnt.model.E.B.class(l2, ApiFilterUtils.getEndTimestamp(this.\u00d200000, l3))).\u00d500000(ApiFilterUtils.getMacFilter(string)).\u00d200000(Optional.ofNullable(n2)).\u00f500000(Object).null();
        return WifiClientStatisticsDto.builder().clientDetails(this.\u00d600000.\u00d500000(if_)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/aps"})
    @Operation(summary="WiFi Access Point statistics", description="Since 7.3")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiApStatisticsDto wifiApStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="watchlistTableSize", required=false) @Min(value=1L) @Parameter(name="Size of top APs list returned") @Min(value=1L) Integer n2) {
        if if_ = if.\u00f400000().\u00d800000(site.getId()).\u00d300000(com.ubnt.model.E.B.class(l2, ApiFilterUtils.getEndTimestamp(this.\u00d200000, l3))).\u00d200000(Optional.ofNullable(n2)).\u00f500000(o00000).null();
        return WifiApStatisticsDto.builder().apDetails(this.\u00d400000.\u00f4O0000(if_)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/radios"})
    @Operation(summary="WiFi Radio statistics", description="Since 7.6.24")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiRadioStatisticsDto wifiRadioStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3) {
        if if_ = if.\u00f400000().\u00d800000(site.getId()).\u00d300000(com.ubnt.model.E.B.class(l2, ApiFilterUtils.getEndTimestamp(this.\u00d200000, l3))).\u00f500000(o00000).null();
        return WifiRadioStatisticsDto.builder().radioDetails(this.\u00d500000.for(if_)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/wifi-stats/channelization"})
    @Operation(summary="WiFi Radio statistics for channelization")
    @ResponseStatus(value=HttpStatus.OK)
    public WifiChannelizationStatisticsDto wifiChannelizationStatistics(@PathVariable(value="siteName") Site site, @RequestParam(value="start") @Parameter(name="Filter start in unix epoch seconds", required=true) Long l2, @RequestParam(value="end", required=false) @Parameter(name="Filter end in unix epoch seconds") Long l3, @RequestParam(value="apMac", required=false) @MacAddress(allowAll=true) @MacAddress(allowAll=true) String string) {
        if if_ = if.\u00f400000().\u00d800000(site.getId()).\u00d300000(com.ubnt.model.E.B.class(l2, ApiFilterUtils.getEndTimestamp(this.\u00d200000, l3))).\u00d500000(ApiFilterUtils.getMacFilter(string)).\u00f500000(o00000).null();
        return WifiChannelizationStatisticsDto.builder().details(this.\u00d500000.\u00d800000(if_)).build();
    }
}

