/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.wireless;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RadioSettings {
    private String radio;
    private String ieeeMode;
    private Integer configuredChannel;
    private Integer actualChannel;
    private Integer txPower;
    private Boolean minRssi;
    private Integer minRssiLevel;
    private Boolean hardNoiseFloor;
    private Integer hardNoiseFloorLevel;
    private Boolean loadBalance;
    private Integer loadBalanceMaxSta;

    public RadioSettings(X x2, X x3, X x4) {
        this.radio = x2.getString("radio");
        this.ieeeMode = x3.getString("ieee_mode", "unknown");
        this.configuredChannel = x3.getInt("channel");
        this.actualChannel = x2.getInt("channel");
        String string = x3.getString("txpower", "auto");
        this.txPower = string.equals("auto") ? Integer.valueOf(-1) : Integer.valueOf(string);
        X x5 = x4.getX("minrssi", X.\u00d5\u00d30000);
        this.minRssi = x5.getBoolean("status");
        this.minRssiLevel = x5.getInt("rssi");
        X x6 = x3.getX("hard_noisefloor", X.\u00d5\u00d30000);
        this.hardNoiseFloor = x6.getBoolean("status");
        this.hardNoiseFloorLevel = x6.getX("minrssi", X.\u00d5\u00d30000).getInt("value") + x6.getInt("minrssi_backoff");
        X x7 = x4.getX("loadbalance", X.\u00d5\u00d30000);
        this.loadBalance = x7.getBoolean("status");
        this.loadBalanceMaxSta = x7.getInt("maxsta");
    }

    public String getRadio() {
        return this.radio;
    }

    public String getIeeeMode() {
        return this.ieeeMode;
    }

    public Integer getConfiguredChannel() {
        return this.configuredChannel;
    }

    public Integer getActualChannel() {
        return this.actualChannel;
    }

    public Integer getTxPower() {
        return this.txPower;
    }

    public Boolean getMinRssi() {
        return this.minRssi;
    }

    public Integer getMinRssiLevel() {
        return this.minRssiLevel;
    }

    public Boolean getHardNoiseFloor() {
        return this.hardNoiseFloor;
    }

    public Integer getHardNoiseFloorLevel() {
        return this.hardNoiseFloorLevel;
    }

    public Boolean getLoadBalance() {
        return this.loadBalance;
    }

    public Integer getLoadBalanceMaxSta() {
        return this.loadBalanceMaxSta;
    }
}

