/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.config.ubios.ospf;

import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.ospf.OspfAuthenticationType;
import com.ubnt.net.return.H;
import com.ubnt.service.ospf.OspfRouterDocument;
import com.ubnt.service.system.oA;
import com.ubnt.udapi.OO0O.ooOO.G;
import com.ubnt.udapi.while;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class M {
    private static final Logger super = oA.\u00f8\u00d30000;

    public List<G> class(OspfRouterDocument ospfRouterDocument, List<NetworkConf> list) {
        return ospfRouterDocument.getAreas().stream().map(ospfAreaDocumentPart -> G.\u00d2\u00f4\u00d4000().\u00d200000(ospfAreaDocumentPart.getAreaId()).o00000(ospfAreaDocumentPart.getAreaType()).String(OspfAuthenticationType.OFF).\u00d300000(ospfAreaDocumentPart.getNetworkIds().stream().flatMap(string -> this.\u00d300000((String)string, list).stream()).flatMap(this::int).toList()).\u00f500000()).filter(g2 -> !g2.\u00d3\u00f4\u00d4000().isEmpty()).toList();
    }

    private Optional<NetworkConf> \u00d300000(String string, List<NetworkConf> list) {
        return list.stream().filter(networkConf -> StringUtils.equals((CharSequence)string, (CharSequence)networkConf.getId())).findAny().or(() -> {
            super.warn("Missing network '{}' assigned to an OSPF Area", (Object)string);
            return Optional.empty();
        });
    }

    private Stream<while> int(NetworkConf networkConf) {
        if (networkConf.isLocalSiteNetwork() || networkConf.isOpenVpnServer() || networkConf.isWireguardClientOrServer()) {
            return Stream.of(while.\u00d300000(networkConf.getSubnet()));
        }
        if (networkConf.isWanNetwork() && networkConf.isStaticWan()) {
            return Stream.concat(M.\u00f400000(networkConf).stream(), networkConf.getWanIpAliases().stream()).flatMap(this::\u00f600000).distinct().map(while::\u00d300000);
        }
        if (networkConf.isOpenVpnClientNetwork()) {
            return Optional.ofNullable(networkConf.getIpSubnetOrNull()).map(while::\u00d300000).or(() -> {
                super.warn("OpenVPN Client '{}' configured to be used in OSPF Area, but IP is missing. OpenVPN Client Client needs to establish successful connection first", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        if (this.\u00d200000(networkConf)) {
            return networkConf.getIpsecTunnelIp().map(H::new).map(while::\u00d300000).or(() -> {
                super.warn("IPSec Site to Site VPN '{}' configured to be used in OSPF Area, but Tunnel IP is missing", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        super.warn("Cannot build OSPF Area for network '{}', purpose: '{}'", (Object)networkConf.getId(), (Object)networkConf.getNetworkPurpose());
        return Stream.empty();
    }

    private static Optional<String> \u00f400000(NetworkConf networkConf) {
        return networkConf.getWanIp().flatMap(string -> {
            String string2 = networkConf.getWanNetmask().orElse("255.255.255.0");
            return H.\u00d3O0000(string, string2);
        }).or(() -> {
            super.warn("Cannot build OSPF Area for WAN network: '{}', ip: '{}', netmask: '{}'", new Object[]{networkConf.getId(), networkConf.getWanIp().orElse(null), networkConf.getWanNetmask().orElse(null)});
            return Optional.empty();
        });
    }

    private boolean \u00d200000(NetworkConf networkConf) {
        return networkConf.isSiteIpsecVpnNetwork() && networkConf.isIpsecDynamicRouting() && networkConf.isIpsecTunnelIpEnabled() && networkConf.isRemoteVpnDynamicSubnetsEnabled();
    }

    private Stream<String> \u00f600000(String string) {
        try {
            return Stream.of(H.new(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            super.warn("Cannot build OSPF area for subnet '{}'", (Object)string);
            return Stream.empty();
        }
    }
}

