/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.sdn;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotMqttClient;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.google.common.util.concurrent.RateLimiter;
import com.ubnt.data.X;
import com.ubnt.service.sso.class;
import com.ubnt.service.system.MA;
import com.ubnt.service.system.O0ooo;
import com.ubnt.service.system.OO0Oo;
import com.ubnt.service.system.Oo0o;
import com.ubnt.service.system.Z;
import com.ubnt.service.system.oA;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

public class DeviceShadow {
    private static final Logger logger = oA.\u00d800000;
    private static final int UNKNOWN_HOST_TYPE = 0;
    private final String deviceId;
    private final Oo0o dbService;
    private final class ssoService;
    private final MA swaiConfigProvider;
    private final AWSIotMqttClient client;
    private final Z systemEnvironmentService;
    private final O0ooo systemService;
    private RateLimiter throttle = RateLimiter.create((double)0.016666666666666666);
    private String name;
    private String version;
    private List<String> ipAddrs;
    private int mgmtPort;
    private int informPort;
    private boolean overrideInformHost;
    private String hostname;
    private int hostType;
    private UUID hardwareId;
    private String state;
    private String loginToken;
    private UUID controllerUuid;
    private String releaseChannel;
    private X ui;

    public DeviceShadow(AWSIotMqttClient aWSIotMqttClient, String string, Oo0o oo0o2, class clazz, MA mA2, Z z2, O0ooo o0ooo2) {
        this.client = aWSIotMqttClient;
        this.deviceId = string;
        this.dbService = oo0o2;
        this.ssoService = clazz;
        this.swaiConfigProvider = mA2;
        this.systemEnvironmentService = z2;
        this.systemService = o0ooo2;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOverrideInformHost(boolean bl) {
        this.overrideInformHost = bl;
    }

    public List<String> getIpAddrs() {
        return this.ipAddrs;
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public int getInformPort() {
        return this.informPort;
    }

    public boolean isOverrideInformHost() {
        return this.overrideInformHost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public int getHostType() {
        return this.hostType;
    }

    public UUID getHardwareId() {
        return this.hardwareId;
    }

    public String getState() {
        return this.state;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public UUID getControllerUuid() {
        return this.controllerUuid;
    }

    public String getReleaseChannel() {
        return this.releaseChannel;
    }

    public void setIpAddrs(List<String> list) {
        this.ipAddrs = list;
    }

    public void update() {
        this.version = this.systemEnvironmentService.O\u00d40000();
        this.name = this.dbService.O\u00d50000("identity").getString("name", "UniFi");
        this.ipAddrs = this.systemEnvironmentService.returnString();
        this.hardwareId = UUID.fromString(this.systemEnvironmentService.Oo0000());
        this.hostType = 0;
        this.hostname = this.dbService.O\u00d50000("identity").getString("hostname", "example-domain.ui.com");
        this.overrideInformHost = this.dbService.O\u00d50000("mgmt").is("override_inform_host", false);
        this.mgmtPort = OO0Oo.\u00d4\u00d40000();
        this.informPort = OO0Oo.doString();
        this.state = "connected";
        this.loginToken = this.ssoService.\u00d400000();
        this.controllerUuid = UUID.fromString(this.systemService.\u00f5\u00f4\u00d8000());
        this.releaseChannel = O0ooo.\u00d30\u00f4000();
        this.ui = new X().append("cdnPublicPaths", List.of(this.swaiConfigProvider.\u00d800000())).append("prefetch", this.swaiConfigProvider.\u00d500000()).append("entrypoint", this.swaiConfigProvider.null()).append("swaiVersion", this.swaiConfigProvider.\u00d600000());
    }

    X toX() {
        X x2 = new X();
        x2.put("name", (Object)this.name);
        x2.put("version", (Object)this.version);
        x2.put("ipAddrs", this.ipAddrs);
        x2.put("mgmt_port", (Object)this.mgmtPort);
        x2.put("inform_port", (Object)this.informPort);
        x2.put("override_inform_host", (Object)this.overrideInformHost);
        x2.put("hostname", (Object)this.hostname);
        x2.put("host_type", (Object)this.hostType);
        x2.put("hardware_id", (Object)this.hardwareId.toString());
        x2.put("state", (Object)this.state);
        x2.put("login_token", (Object)this.loginToken);
        x2.put("controller_uuid", (Object)this.controllerUuid.toString());
        x2.put("firmware_version", null);
        x2.put("release_channel", (Object)this.releaseChannel);
        x2.put("ui", (Object)this.ui);
        return new X("state", new X("reported", x2));
    }

    public void sync() {
        try {
            this.client.publish(new AWSIotMessage("device/" + this.deviceId + "/state", AWSIotQos.QOS0, this.toX().toString()));
        }
        catch (AWSIotException aWSIotException) {
            logger.error(AnalyticsAppender.SEND_TO_ANALYTICS, "failed to sync device shadow", (Throwable)aWSIotException);
        }
    }

    public void syncUpdate() {
        if (!this.throttle.tryAcquire()) {
            logger.warn("too many update state attempts");
            return;
        }
        this.update();
        this.sync();
    }
}

