/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.sslinspection.logs.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OoOO.C;
import com.ubnt.model.api.inspection.InspectionLogSource;
import com.ubnt.model.api.sslinspection.SslInspectionRisk;
import com.ubnt.service.client.A.Z;
import com.ubnt.service.inspectionlogs.InspectionLogDocument;
import com.ubnt.service.inspectionlogs.SslInspectionLogDocumentPart;
import com.ubnt.service.inspectionlogs.String;
import com.ubnt.service.sslinspection.logs.model.ImmutableSslInspectionFirmwareEventDto;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventMessageDto;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventMessageKind;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventProtocol;
import com.ubnt.service.sslinspection.logs.model.SslInspectionEventType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableSslInspectionFirmwareEventDto.Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@C
public interface SslInspectionFirmwareEventDto {
    @JsonProperty(value="time")
    public LocalDateTime time();

    @JsonProperty(value="type")
    public SslInspectionEventType type();

    @JsonProperty(value="gateway_mac")
    public java.lang.String gatewayMac();

    @JsonProperty(value="client_ip")
    public java.lang.String clientIp();

    @JsonProperty(value="client_port")
    public int clientPort();

    @JsonProperty(value="server_ip")
    public java.lang.String serverIp();

    @JsonProperty(value="server_port")
    public int serverPort();

    @JsonProperty(value="protocol")
    public SslInspectionEventProtocol protocol();

    @JsonProperty(value="risk")
    public Optional<SslInspectionRisk> risk();

    @JsonProperty(value="message")
    public SslInspectionEventMessageDto message();

    default public InspectionLogDocument toDocument(java.lang.String string, ZoneId zoneId, Z z2) {
        SslInspectionEventMessageDto sslInspectionEventMessageDto = this.message();
        return InspectionLogDocument.builder().\u00d600000(string).void(this.getAction()).oO0000(this.getLogSource()).\u00d400000(this.time().atZone(zoneId).toEpochSecond()).\u00d200000(z2.\u00f6O0000()).\u00f600000(z2.O\u00d20000()).o00000(this.clientIp()).OO0000(this.clientPort()).\u00f400000(this.serverIp()).\u00f500000(this.serverPort()).Object(this.risk().map(SslInspectionRisk::toInspectionLogRisk).orElse(null)).\u00d4O0000(SslInspectionLogDocumentPart.builder().\u00d600000(this.protocol()).\u00d300000(sslInspectionEventMessageDto.path()).null(sslInspectionEventMessageDto.domain()).\u00d500000(sslInspectionEventMessageDto.kind()).String(sslInspectionEventMessageDto.detail()).\u00d200000(this.type()).\u00d800000(sslInspectionEventMessageDto.action().orElse(null)).o00000()).float();
    }

    default public InspectionLogSource getLogSource() {
        return switch (this.type()) {
            default -> throw new IncompatibleClassChangeError();
            case SslInspectionEventType.APP_ALLOW, SslInspectionEventType.APP_BLOCK -> InspectionLogSource.SSL_APP;
            case SslInspectionEventType.CERTIFICATE_BLOCK -> InspectionLogSource.SSL_CERTIFICATE;
            case SslInspectionEventType.FILE_ALLOW, SslInspectionEventType.FILE_BLOCK -> InspectionLogSource.SSL_FILE;
            case SslInspectionEventType.QUERY_ALLOW, SslInspectionEventType.QUERY_BLOCK -> InspectionLogSource.SSL_QUERY;
            case SslInspectionEventType.RISK_BLOCK -> InspectionLogSource.SSL_RISK_BLOCK;
            case SslInspectionEventType.URL_ALLOW, SslInspectionEventType.URL_BLOCK -> InspectionLogSource.SSL_URL;
            case SslInspectionEventType.INSPECT -> {
                if (this.message().kind() == SslInspectionEventMessageKind.SEARCH_ENGINE) {
                    yield InspectionLogSource.SSL_QUERY;
                }
                yield InspectionLogSource.SSL_INSPECT;
            }
            case SslInspectionEventType.BYPASS -> InspectionLogSource.SSL_BYPASS;
        };
    }

    default public String getAction() {
        return switch (this.type()) {
            default -> throw new IncompatibleClassChangeError();
            case SslInspectionEventType.APP_ALLOW, SslInspectionEventType.FILE_ALLOW, SslInspectionEventType.URL_ALLOW -> String.\u00d400000;
            case SslInspectionEventType.APP_BLOCK, SslInspectionEventType.CERTIFICATE_BLOCK, SslInspectionEventType.FILE_BLOCK, SslInspectionEventType.QUERY_BLOCK, SslInspectionEventType.RISK_BLOCK, SslInspectionEventType.URL_BLOCK -> String.o00000;
            case SslInspectionEventType.QUERY_ALLOW, SslInspectionEventType.BYPASS -> String.\u00d300000;
            case SslInspectionEventType.INSPECT -> this.message().kind() == SslInspectionEventMessageKind.SEARCH_ENGINE ? String.\u00d400000 : String.\u00d300000;
        };
    }

    public static ImmutableSslInspectionFirmwareEventDto.Builder builder() {
        return ImmutableSslInspectionFirmwareEventDto.builder();
    }
}

