/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OoOO.C;
import com.ubnt.service.trace.api.device.TraceDeviceStats;
import com.ubnt.service.trace.api.internal.ImmutableDebugEventReport;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonSerialize(as=ImmutableDebugEventReport.class)
@JsonDeserialize(as=ImmutableDebugEventReport.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
@C
public abstract class DebugEventReport {
    @Nullable
    @JsonProperty(value="message")
    public abstract String message();

    @Nullable
    @JsonProperty(value="deviceStats")
    public abstract TraceDeviceStats deviceStats();

    @Nullable
    @JsonProperty(value="additionalStats")
    public abstract Map<String, Object> additionalStats();

    @Nullable
    @JsonIgnore
    abstract Exception super();

    @Nullable
    @JsonProperty(value="exceptionStackTrace")
    @Value.Derived
    public List<String> exceptionStackTrace() {
        if (this.super() == null) {
            return null;
        }
        return Stream.of(this.super().getStackTrace()).map(Object::toString).collect(Collectors.toList());
    }

    @Nullable
    @JsonProperty(value="exceptionName")
    @Value.Derived
    public String exceptionName() {
        return Optional.ofNullable(this.super()).map(Object::getClass).map(Class::getName).orElse(null);
    }
}

