/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Crossover;
import io.jenetics.Gene;
import io.jenetics.internal.math.random;
import io.jenetics.internal.util.require;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;

public class UniformCrossover<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Crossover<G, C> {
    private final double _swapProbability;

    public UniformCrossover(double crossoverProbability, double swapProbability) {
        super(crossoverProbability);
        this._swapProbability = require.probability(swapProbability);
    }

    public UniformCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.2);
    }

    public UniformCrossover() {
        this(0.2, 0.2);
    }

    public double getSwapProbability() {
        return this._swapProbability;
    }

    @Override
    protected int crossover(MSeq<G> that, MSeq<G> other) {
        int length = Math.min(that.length(), other.length());
        return (int)random.indexes(RandomRegistry.getRandom(), length, this._swapProbability).peek(i -> that.swap(i, other)).count();
    }
}

