/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.coremod.ICoreModFile;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CoreModFile
implements ICoreModFile {
    private final Path internalPath;
    private final ModFile file;
    private final String name;

    CoreModFile(String name, Path path, ModFile file) {
        this.name = name;
        this.internalPath = path;
        this.file = file;
    }

    public Reader readCoreMod() throws IOException {
        return Files.newBufferedReader(this.internalPath);
    }

    public Path getPath() {
        return this.internalPath;
    }

    public Reader getAdditionalFile(String fileName) throws IOException {
        return Files.newBufferedReader(this.file.findResource(fileName));
    }

    public String getOwnerId() {
        return this.file.getModInfos().get(0).getModId();
    }

    public String toString() {
        return "{Name: " + this.name + ", Owner: " + this.getOwnerId() + " @ " + String.valueOf(this.getPath()) + "}";
    }
}

