/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.BlockHitResult;

public class PumpkinBlock
extends Block {
    public static final MapCodec<PumpkinBlock> CODEC = PumpkinBlock.simpleCodec(PumpkinBlock::new);

    public MapCodec<PumpkinBlock> codec() {
        return CODEC;
    }

    protected PumpkinBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected InteractionResult useItemOn(ItemStack $$0, BlockState $$1, Level $$2, BlockPos $$32, Player $$42, InteractionHand $$5, BlockHitResult $$6) {
        void $$8;
        if (!$$0.is(Items.SHEARS)) {
            return super.useItemOn($$0, $$1, $$2, $$32, $$42, $$5, $$6);
        }
        if (!($$2 instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel $$7 = (ServerLevel)$$2;
        Direction $$9 = $$6.getDirection();
        Direction $$10 = $$9.getAxis() == Direction.Axis.Y ? $$42.getDirection().getOpposite() : $$9;
        PumpkinBlock.dropFromBlockInteractLootTable((ServerLevel)$$8, BuiltInLootTables.CARVE_PUMPKIN, $$1, $$2.getBlockEntity($$32), $$0, $$42, ($$3, $$4) -> {
            ItemEntity $$5 = new ItemEntity($$2, (double)$$32.getX() + 0.5 + (double)$$10.getStepX() * 0.65, (double)$$32.getY() + 0.1, (double)$$32.getZ() + 0.5 + (double)$$10.getStepZ() * 0.65, (ItemStack)$$4);
            $$5.setDeltaMovement(0.05 * (double)$$10.getStepX() + $$0.random.nextDouble() * 0.02, 0.05, 0.05 * (double)$$10.getStepZ() + $$0.random.nextDouble() * 0.02);
            $$2.addFreshEntity($$5);
        });
        $$2.playSound(null, $$32, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        $$2.setBlock($$32, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(CarvedPumpkinBlock.FACING, $$10), 11);
        $$0.hurtAndBreak(1, (LivingEntity)$$42, $$5.asEquipmentSlot());
        $$2.gameEvent((Entity)$$42, GameEvent.SHEAR, $$32);
        $$42.awardStat(Stats.ITEM_USED.get(Items.SHEARS));
        return InteractionResult.SUCCESS;
    }
}

