/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/rtp/util/BitWriter;", "", "buf", "", "byteOffset", "", "byteLength", "<init>", "([BII)V", "getBuf", "()[B", "getByteOffset", "()I", "offset", "byteBound", "writeBit", "", "value", "", "writeBits", "bits", "writeNs", "n", "v", "remainingBits", "getRemainingBits", "rtp"})
public final class BitWriter {
    @NotNull
    private final byte[] buf;
    private final int byteOffset;
    private final int byteLength;
    private int offset;
    private final int byteBound;

    public BitWriter(@NotNull byte[] buf, int byteOffset, int byteLength) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.buf = buf;
        this.byteOffset = byteOffset;
        this.byteLength = byteLength;
        this.offset = this.byteOffset * 8;
        this.byteBound = this.byteOffset + this.byteLength;
        Arrays.fill(this.buf, this.byteOffset, this.byteBound, (byte)0);
    }

    public /* synthetic */ BitWriter(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    public final void writeBit(boolean value) {
        int byteIdx = this.offset / 8;
        int bitIdx = this.offset % 8;
        if (!(byteIdx < this.byteBound)) {
            boolean bl = false;
            String string = "offset " + this.offset + " (" + byteIdx + "/" + bitIdx + ") invalid in buffer of length " + this.byteLength + " after offset " + this.byteOffset;
            throw new IllegalStateException(string.toString());
        }
        if (value) {
            this.buf[byteIdx] = (byte)(this.buf[byteIdx] | (byte)(1 << 7 - bitIdx));
        }
        int n = this.offset;
        this.offset = n + 1;
    }

    public final void writeBits(int bits, int value) {
        if (!(value < 1 << bits)) {
            boolean $i$a$-check-BitWriter$writeBits$22 = false;
            String $i$a$-check-BitWriter$writeBits$22 = "value " + value + " cannot be represented in " + bits + " bits";
            throw new IllegalStateException($i$a$-check-BitWriter$writeBits$22.toString());
        }
        for (int i = 0; i < bits; ++i) {
            int i2 = i;
            boolean bl = false;
            this.writeBit((value & 1 << bits - i2 - 1) != 0);
        }
    }

    public final void writeNs(int n, int v) {
        if (n == 1) {
            return;
        }
        int w = 0;
        int x = n;
        while (x != 0) {
            x >>= 1;
            ++w;
        }
        int m = (1 << w) - n;
        if (v < m) {
            this.writeBits(w - 1, v);
        } else {
            this.writeBits(w, v + m);
        }
    }

    public final int getRemainingBits() {
        return this.byteBound * 8 - this.offset;
    }
}

