/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Paths;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.license.License;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.HintManager;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmLazyMenuAdapter;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.AboutAction;
import org.tinymediamanager.ui.actions.BugReportAction;
import org.tinymediamanager.ui.actions.CheckForUpdateAction;
import org.tinymediamanager.ui.actions.ClearDatabaseAction;
import org.tinymediamanager.ui.actions.ClearHttpCacheAction;
import org.tinymediamanager.ui.actions.ClearImageCacheAction;
import org.tinymediamanager.ui.actions.CloseTmmAction;
import org.tinymediamanager.ui.actions.CreateDesktopFileAction;
import org.tinymediamanager.ui.actions.DeleteTrashAction;
import org.tinymediamanager.ui.actions.DocsAction;
import org.tinymediamanager.ui.actions.ExportAnalysisDataAction;
import org.tinymediamanager.ui.actions.ExportLogAction;
import org.tinymediamanager.ui.actions.FaqAction;
import org.tinymediamanager.ui.actions.ForumAction;
import org.tinymediamanager.ui.actions.HomepageAction;
import org.tinymediamanager.ui.actions.ImportV4DataAction;
import org.tinymediamanager.ui.actions.RebuildImageCacheAction;
import org.tinymediamanager.ui.actions.ShowChangelogAction;
import org.tinymediamanager.ui.actions.UnlockAction;
import org.tinymediamanager.ui.components.toolbar.ToolbarButton;
import org.tinymediamanager.ui.dialogs.ActivityLogDialog;
import org.tinymediamanager.ui.dialogs.FullLogDialog;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieJmteExplorerDialog;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowJmteExplorerDialog;

public class MainMenuPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenuPanel.class);
    private final JPanel contentPanel;
    private final ButtonGroup buttons = new ButtonGroup();
    private final JPopupMenu menuTools;
    private final JPopupMenu menuInfo;

    public MainMenuPanel() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 0, gapy 15lp, wrap", "[center]", "32lp[]"));
        this.contentPanel.setOpaque(false);
        this.add((Component)this.contentPanel, "Center");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("insets 0, gapy 15lp, wrap", "[center, grow]", "[]10lp"));
        bottomPanel.setOpaque(false);
        this.add((Component)bottomPanel, "South");
        this.menuTools = this.buildToolsMenu();
        ToolbarButton btnTools = new ToolbarButton(IconManager.TOOLBAR_TOOLS, (Icon)IconManager.TOOLBAR_TOOLS_HOVER, this.menuTools);
        btnTools.setToolTipText(TmmResourceBundle.getString("Toolbar.tools"));
        bottomPanel.add((Component)btnTools, "growx");
        ToolbarButton btnSettings = new ToolbarButton((Icon)IconManager.TOOLBAR_SETTINGS, (Icon)IconManager.TOOLBAR_SETTINGS_HOVER);
        btnSettings.setToolTipText(TmmResourceBundle.getString("Toolbar.settings"));
        btnSettings.addActionListener(listener -> {
            JDialog settingsDialog = SettingsDialog.getInstance();
            settingsDialog.setVisible(true);
        });
        bottomPanel.add((Component)btnSettings, "growx");
        this.menuInfo = this.buildInfoMenu();
        ToolbarButton btnInfo = new ToolbarButton(IconManager.TOOLBAR_ABOUT, (Icon)IconManager.TOOLBAR_ABOUT_HOVER, this.menuInfo);
        btnInfo.setToolTipText(TmmResourceBundle.getString("Toolbar.help"));
        bottomPanel.add((Component)btnInfo, "growx");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tmm.toolbar.background"));
    }

    public void addModule(ITmmUIModule module) {
        ModuleButton btnModule = new ModuleButton(module);
        btnModule.setToolTipText(module.getTabTitle());
        this.contentPanel.add((Component)btnModule, "gapx 1lp 1lp");
        this.buttons.add(btnModule);
        if (module instanceof MovieUIModule) {
            btnModule.setSelected(true);
            HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.module"), btnModule, 4);
        }
    }

    public JPopupMenu getToolsMenu() {
        return this.menuTools;
    }

    public JPopupMenu getInfoMenu() {
        return this.menuInfo;
    }

    private JPopupMenu buildToolsMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ClearImageCacheAction());
        menu.add(new RebuildImageCacheAction());
        menu.add(new ClearHttpCacheAction());
        menu.addSeparator();
        JMenuItem tmmLogs = new JMenuItem(TmmResourceBundle.getString("tmm.activitylog"));
        menu.add(tmmLogs);
        tmmLogs.addActionListener(arg0 -> {
            ActivityLogDialog logDialog = new ActivityLogDialog();
            logDialog.setLocationRelativeTo(MainWindow.getInstance());
            ((Dialog)logDialog).setVisible(true);
        });
        JMenuItem tmmMessages = new JMenuItem(TmmResourceBundle.getString("tmm.messages"));
        tmmMessages.setMnemonic(76);
        menu.add(tmmMessages);
        tmmMessages.addActionListener(arg0 -> {
            MessageHistoryDialog messageDialog = MessageHistoryDialog.getInstance();
            ((Dialog)messageDialog).setVisible(true);
        });
        JMenuItem tmmFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gotoinstalldir"));
        menu.add(tmmFolder);
        tmmFolder.setToolTipText(TmmResourceBundle.getString("tmm.gotoinstalldir.desc"));
        tmmFolder.addActionListener(arg0 -> TmmUIHelper.openFolder(Paths.get(System.getProperty("user.dir"), new String[0])));
        JMenuItem contentFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gotocontentdir"));
        menu.add(contentFolder);
        contentFolder.setToolTipText(TmmResourceBundle.getString("tmm.gotocontentdir.desc"));
        contentFolder.addActionListener(arg0 -> TmmUIHelper.openFolder(Paths.get(Globals.CONTENT_FOLDER, new String[0])));
        JMenuItem dataFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gotodatadir"));
        menu.add(dataFolder);
        dataFolder.setToolTipText(TmmResourceBundle.getString("tmm.gotodatadir.desc"));
        dataFolder.addActionListener(arg0 -> TmmUIHelper.openFolder(Paths.get(Globals.DATA_FOLDER, new String[0])));
        JMenuItem logFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gotologdir"));
        menu.add(logFolder);
        logFolder.setToolTipText(TmmResourceBundle.getString("tmm.gotologdir.desc"));
        logFolder.addActionListener(arg0 -> TmmUIHelper.openFolder(Paths.get(Globals.LOG_FOLDER, new String[0])));
        JMenuItem tmpFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gototmpdir"));
        menu.add(tmpFolder);
        tmpFolder.addActionListener(arg0 -> TmmUIHelper.openFolder(Paths.get(Utils.getTempFolder(), new String[0])));
        menu.add(new DeleteTrashAction());
        menu.addSeparator();
        JMenu menuWakeOnLan = new JMenu(TmmResourceBundle.getString("tmm.wakeonlan"));
        menuWakeOnLan.setMnemonic(87);
        menuWakeOnLan.addMenuListener(new TmmLazyMenuAdapter(){

            @Override
            protected void menuWillBecomeVisible(JMenu menu) {
                menu.removeAll();
                for (WolDevice device : Settings.getInstance().getWolDevices()) {
                    JMenuItem item = new JMenuItem(device.getName());
                    item.addActionListener(arg01 -> Utils.sendWakeOnLanPacket(device.getMacAddress()));
                    menu.add(item);
                }
            }
        });
        menu.add(menuWakeOnLan);
        JMenu kodiRPCMenu = KodiRPCMenu.createKodiMenuTop();
        menu.add(kodiRPCMenu);
        menu.addPopupMenuListener(new TmmLazyMenuAdapter(){

            @Override
            protected void menuWillBecomeVisible(JMenu menu) {
                if (!Settings.getInstance().getWolDevices().isEmpty()) {
                    menu.setEnabled(true);
                } else {
                    menu.setEnabled(false);
                }
                AbstractButton kodiRPCMenu = null;
                for (Component comp : menu.getMenuComponents()) {
                    JMenu subMenu;
                    if (!(comp instanceof JMenu) || (subMenu = (JMenu)comp).getIcon() != IconManager.KODI) continue;
                    kodiRPCMenu = subMenu;
                    break;
                }
                if (kodiRPCMenu != null) {
                    if (KodiRPC.getInstance().isConnected()) {
                        kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                        ((JMenuItem)kodiRPCMenu).setEnabled(true);
                    } else {
                        kodiRPCMenu.setText("Kodi");
                        ((JMenuItem)kodiRPCMenu).setEnabled(false);
                    }
                }
            }
        });
        menu.addSeparator();
        JMenu jmteExplorerMenu = new JMenu(TmmResourceBundle.getString("jmteexplorer.title"));
        JMenuItem movieJmteExplorer = new JMenuItem(TmmResourceBundle.getString("tmm.movies"));
        movieJmteExplorer.addActionListener(arg0 -> new MovieJmteExplorerDialog((Window)MainWindow.getInstance()).setVisible(true));
        jmteExplorerMenu.add(movieJmteExplorer);
        JMenuItem tvShowJmteExplorer = new JMenuItem(TmmResourceBundle.getString("tmm.tvshows"));
        tvShowJmteExplorer.addActionListener(arg0 -> new TvShowJmteExplorerDialog((Window)MainWindow.getInstance()).setVisible(true));
        jmteExplorerMenu.add(tvShowJmteExplorer);
        menu.add(jmteExplorerMenu);
        if (Globals.canCheckForUpdates() || Globals.isDebug()) {
            menu.addSeparator();
        }
        if (Globals.canCheckForUpdates()) {
            menu.add(new CheckForUpdateAction());
        }
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            JMenuItem trace = new JMenuItem("set Console Logger to TRACE");
            trace.addActionListener(arg0 -> {
                System.setProperty("tmm.consoleloglevel", "TRACE");
                TinyMediaManager.setLogLevels();
                MessageManager.getInstance().pushMessage(new Message("Trace levels set!", "Test"));
                LOGGER.trace("if you see that, we're now on TRACE logging level ;)");
            });
            debugMenu.add(trace);
            JMenuItem traceLogs = new JMenuItem("Show all logs from this session");
            debugMenu.add(traceLogs);
            traceLogs.addActionListener(arg0 -> {
                FullLogDialog logDialog = new FullLogDialog();
                logDialog.setLocationRelativeTo(MainWindow.getInstance());
                ((Dialog)logDialog).setVisible(true);
            });
            menu.add(debugMenu);
        }
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.add(new ExportLogAction());
        menu.add(new ExportAnalysisDataAction());
        if (SystemUtils.IS_OS_LINUX) {
            menu.addSeparator();
            menu.add(new CreateDesktopFileAction());
        }
        menu.addSeparator();
        menu.add(new ClearDatabaseAction());
        menu.add(new ImportV4DataAction());
        if (SystemUtils.IS_OS_LINUX) {
            menu.addSeparator();
            menu.add(new CloseTmmAction());
        }
        return menu;
    }

    private JPopupMenu buildInfoMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new FaqAction());
        menu.add(new DocsAction());
        menu.add(new ForumAction());
        menu.add(new ShowChangelogAction());
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.addSeparator();
        if (!License.getInstance().isValidLicense()) {
            menu.add(new UnlockAction());
        }
        menu.add(new HomepageAction());
        menu.add(new AboutAction());
        return menu;
    }

    private static class ModuleButton
    extends JToggleButton {
        private final Icon icon;
        private final Icon activeIcon;

        private ModuleButton(ITmmUIModule module) {
            super(module.getMenuIcon());
            this.icon = module.getMenuIcon();
            this.activeIcon = module.getMenuActiveIcon();
            this.putClientProperty("tmm.module", module);
            this.init();
        }

        private void init() {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.addItemListener(l -> {
                if (this.isSelected()) {
                    this.setIcon(this.activeIcon);
                    MainWindow.getInstance().setActiveModule((ITmmUIModule)this.getClientProperty("tmm.module"));
                } else {
                    this.setIcon(this.icon);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }
    }
}

