/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.core;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import com.amazonaws.services.iot.client.core.AwsIotRuntimeException;
import com.amazonaws.services.iot.client.mqtt.AwsIotMqttConnection;
import com.amazonaws.services.iot.client.util.AwsIotWebSocketUrlSigner;
import java.util.HashSet;
import java.util.Set;

public class AwsIotWebsocketConnection
extends AwsIotMqttConnection {
    private AwsIotWebSocketUrlSigner urlSigner;

    public AwsIotWebsocketConnection(AbstractAwsIotClient client, String awsAccessKeyId, String awsSecretAccessKey) throws AWSIotException {
        this(client, awsAccessKeyId, awsSecretAccessKey, null);
    }

    public AwsIotWebsocketConnection(AbstractAwsIotClient client, String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) throws AWSIotException {
        super(client, null, "wss://" + client.getClientEndpoint() + ":443");
        this.urlSigner = new AwsIotWebSocketUrlSigner(client.getClientEndpoint() + ":443");
        this.urlSigner.updateCredentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
    }

    @Override
    public void updateCredentials(String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
        this.urlSigner.updateCredentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
    }

    @Override
    public Set<String> getServerUris() {
        HashSet<String> uris = new HashSet<String>();
        try {
            uris.add(this.urlSigner.getSignedUrl(null));
        }
        catch (AWSIotException e) {
            throw new AwsIotRuntimeException(e);
        }
        return uris;
    }
}

