/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.pd.PDObject;

public class COSTrailer
extends PDObject {
    public COSTrailer() {
        this.setObject(COSDictionary.construct(), false);
    }

    public Long getSize() {
        COSObject size = this.getObject().getKey(ASAtom.SIZE);
        if (size != null) {
            if (Boolean.TRUE.equals(size.isIndirect())) {
                throw new VeraPDFParserException("Entry Size in trailer is indirect");
            }
            return size.getInteger();
        }
        return null;
    }

    public void setSize(Long size) {
        Long prevSize;
        if (this.getPrev() != null && this.getPrev() != 0L && (prevSize = this.getObject().getIntegerKey(ASAtom.SIZE)) > size) {
            return;
        }
        this.getObject().setIntegerKey(ASAtom.SIZE, size);
    }

    public Long getPrev() {
        COSObject prev = this.getObject().getKey(ASAtom.PREV);
        if (prev != null) {
            if (Boolean.TRUE.equals(prev.isIndirect())) {
                throw new VeraPDFParserException("Entry Prev in trailer is indirect");
            }
            return prev.getInteger();
        }
        return null;
    }

    public void setPrev(Long prev) {
        if (prev != 0L) {
            this.getObject().setIntegerKey(ASAtom.PREV, prev);
        } else {
            this.removeKey(ASAtom.PREV);
        }
    }

    public Long getXRefStm() {
        return this.getObject().getIntegerKey(ASAtom.XREF_STM);
    }

    public void setXRefStm(Long prev) {
        if (prev != 0L) {
            this.getObject().setIntegerKey(ASAtom.XREF_STM, prev);
        } else {
            this.removeKey(ASAtom.XREF_STM);
        }
    }

    public COSObject getRoot() {
        return this.getKey(ASAtom.ROOT);
    }

    public void setRoot(COSObject root) {
        this.setKey(ASAtom.ROOT, root);
    }

    public COSObject getEncrypt() {
        return this.getKey(ASAtom.ENCRYPT);
    }

    public void setEncrypt(COSObject encrypt) {
        this.setKey(ASAtom.ENCRYPT, encrypt);
    }

    public COSObject getInfo() {
        return this.getKey(ASAtom.INFO);
    }

    public void setInfo(COSObject info) {
        this.setKey(ASAtom.INFO, info);
    }

    public COSObject getID() {
        return this.getKey(ASAtom.ID);
    }

    public void setID(COSObject id) {
        this.getObject().setArrayKey(ASAtom.ID, id);
    }
}

