/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput $$0, Set<ResourceKey<LootTable>> $$1, List<SubProviderEntry> $$2, CompletableFuture<HolderLookup.Provider> $$3) {
        this.pathProvider = $$0.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.subProviders = $$2;
        this.requiredTables = $$1;
        this.registries = $$3;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput $$0) {
        return this.registries.thenCompose($$1 -> this.run($$0, (HolderLookup.Provider)$$1));
    }

    private CompletableFuture<?> run(CachedOutput $$02, HolderLookup.Provider $$12) {
        MappedRegistry<LootTable> $$22 = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap $$3 = new Object2ObjectOpenHashMap();
        this.subProviders.forEach(arg_0 -> LootTableProvider.lambda$run$2($$12, (Map)$$3, $$22, arg_0));
        $$22.freeze();
        ProblemReporter.Collector $$4 = new ProblemReporter.Collector();
        RegistryAccess.Frozen $$5 = new RegistryAccess.ImmutableRegistryAccess(List.of($$22)).freeze();
        ValidationContext $$6 = new ValidationContext($$4, LootContextParamSets.ALL_PARAMS, $$5);
        Sets.SetView $$7 = Sets.difference(this.requiredTables, $$22.registryKeySet());
        for (ResourceKey $$8 : $$7) {
            $$4.report("Missing built-in table: " + String.valueOf($$8.location()));
        }
        $$22.listElements().forEach($$1 -> ((LootTable)$$1.value()).validate($$6.setContextKeySet(((LootTable)$$1.value()).getParamSet()).enterElement("{" + String.valueOf($$1.key().location()) + "}", $$1.key())));
        Multimap<String, String> $$9 = $$4.get();
        if (!$$9.isEmpty()) {
            $$9.forEach(($$0, $$1) -> LOGGER.warn("Found validation problem in {}: {}", $$0, $$1));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])$$22.entrySet().stream().map($$2 -> {
            ResourceKey $$3 = (ResourceKey)$$2.getKey();
            LootTable $$4 = (LootTable)$$2.getValue();
            Path $$5 = this.pathProvider.json($$3.location());
            return DataProvider.saveStable($$02, $$12, LootTable.DIRECT_CODEC, $$4, $$5);
        }).toArray(CompletableFuture[]::new));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> $$0) {
        return $$0.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider $$0, Map $$1, WritableRegistry $$2, SubProviderEntry $$32) {
        $$32.provider().apply($$0).generate(($$3, $$4) -> {
            ResourceLocation $$5 = LootTableProvider.sequenceIdForLootTable($$3);
            ResourceLocation $$6 = $$1.put(RandomSequence.seedForKey($$5), $$5);
            if ($$6 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf($$6) + " and " + String.valueOf($$3.location()));
            }
            $$4.setRandomSequence($$5);
            LootTable $$7 = $$4.setParamSet($$1.paramSet).build();
            $$2.register($$3, $$7, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, LootTableSubProvider> provider, ContextKeySet paramSet) {
    }
}

