/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public ProfiledReloadInstance(ResourceManager $$0, List<PreparableReloadListener> $$12, Executor $$22, Executor $$3, CompletableFuture<Unit> $$42) {
        super($$22, $$3, $$0, $$12, ($$1, $$2, $$32, $$4, $$5) -> {
            AtomicLong $$6 = new AtomicLong();
            AtomicLong $$7 = new AtomicLong();
            CompletableFuture<Void> $$8 = $$32.reload($$1, $$2, ProfiledReloadInstance.profiledExecutor($$4, $$6, $$32.getName()), ProfiledReloadInstance.profiledExecutor($$5, $$7, $$32.getName()));
            return $$8.thenApplyAsync($$3 -> {
                LOGGER.debug("Finished reloading {}", (Object)$$32.getName());
                return new State($$32.getName(), $$6, $$7);
            }, $$3);
        }, $$42);
        this.total.start();
        this.allDone = this.allDone.thenApplyAsync(this::finish, $$3);
    }

    private static Executor profiledExecutor(Executor $$0, AtomicLong $$1, String $$2) {
        return $$3 -> $$0.execute(() -> {
            Runnable $$3 = Profiler.get();
            $$3.push($$2);
            long $$4 = Util.getNanos();
            $$3.run();
            $$1.addAndGet(Util.getNanos() - $$4);
            $$3.pop();
        });
    }

    private List<State> finish(List<State> $$0) {
        this.total.stop();
        long $$1 = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (State $$2 : $$0) {
            long $$3 = TimeUnit.NANOSECONDS.toMillis($$2.preparationNanos.get());
            long $$4 = TimeUnit.NANOSECONDS.toMillis($$2.reloadNanos.get());
            long $$5 = $$3 + $$4;
            String $$6 = $$2.name;
            LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{$$6, $$5, $$3, $$4});
            $$1 += $$4;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)$$1);
        return $$0;
    }

    public record State(String name, AtomicLong preparationNanos, AtomicLong reloadNanos) {
    }
}

