/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.datafix.FixWolfHealth;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementsFix;
import net.minecraft.util.datafix.fixes.AdvancementsRenameFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudPotionFix;
import net.minecraft.util.datafix.fixes.AttributeIdPrefixFix;
import net.minecraft.util.datafix.fixes.AttributeModifierIdFix;
import net.minecraft.util.datafix.fixes.AttributesRenameLegacy;
import net.minecraft.util.datafix.fixes.BannerEntityCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.BedItemColorFix;
import net.minecraft.util.datafix.fixes.BeehiveFieldRenameFix;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColorFix;
import net.minecraft.util.datafix.fixes.BlockEntityBlockStateFix;
import net.minecraft.util.datafix.fixes.BlockEntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.BlockEntityFurnaceBurnTimeFix;
import net.minecraft.util.datafix.fixes.BlockEntityIdFix;
import net.minecraft.util.datafix.fixes.BlockEntityJukeboxFix;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.BlockEntityShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.BlockEntityUUIDFix;
import net.minecraft.util.datafix.fixes.BlockNameFlatteningFix;
import net.minecraft.util.datafix.fixes.BlockPosFormatAndRenamesFix;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.BlockStateStructureTemplateFix;
import net.minecraft.util.datafix.fixes.BoatSplitFix;
import net.minecraft.util.datafix.fixes.CarvingStepRemoveFix;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChestedHorsesInventoryZeroIndexingFix;
import net.minecraft.util.datafix.fixes.ChunkBedBlockEntityInjecterFix;
import net.minecraft.util.datafix.fixes.ChunkBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteLightFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ChunkToProtochunkFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.ContainerBlockEntityLockPredicateFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.CustomModelDataExpandFix;
import net.minecraft.util.datafix.fixes.DecoratedPotFieldRenameFix;
import net.minecraft.util.datafix.fixes.DropInvalidSignDataFix;
import net.minecraft.util.datafix.fixes.DyeItemRenameFix;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EmptyItemInHotbarFix;
import net.minecraft.util.datafix.fixes.EmptyItemInVillagerTradeFix;
import net.minecraft.util.datafix.fixes.EntityArmorStandSilentFix;
import net.minecraft.util.datafix.fixes.EntityAttributeBaseValueFix;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.EntityBrushableBlockFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.EntityElderGuardianSplitFix;
import net.minecraft.util.datafix.fixes.EntityEquipmentToArmorAndHandFix;
import net.minecraft.util.datafix.fixes.EntityFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntityHealthFix;
import net.minecraft.util.datafix.fixes.EntityHorseSaddleFix;
import net.minecraft.util.datafix.fixes.EntityHorseSplitFix;
import net.minecraft.util.datafix.fixes.EntityIdFix;
import net.minecraft.util.datafix.fixes.EntityItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityMinecartIdentifiersFix;
import net.minecraft.util.datafix.fixes.EntityPaintingItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityPaintingMotiveFix;
import net.minecraft.util.datafix.fixes.EntityProjectileOwnerFix;
import net.minecraft.util.datafix.fixes.EntityPufferfishRenameFix;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRedundantChanceTagsFix;
import net.minecraft.util.datafix.fixes.EntityRidingToPassengersFix;
import net.minecraft.util.datafix.fixes.EntitySalmonSizeFix;
import net.minecraft.util.datafix.fixes.EntityShulkerColorFix;
import net.minecraft.util.datafix.fixes.EntityShulkerRotationFix;
import net.minecraft.util.datafix.fixes.EntitySkeletonSplitFix;
import net.minecraft.util.datafix.fixes.EntityStringUuidFix;
import net.minecraft.util.datafix.fixes.EntityTheRenameningFix;
import net.minecraft.util.datafix.fixes.EntityTippedArrowFix;
import net.minecraft.util.datafix.fixes.EntityUUIDFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.EntityWolfColorFix;
import net.minecraft.util.datafix.fixes.EntityZombieSplitFix;
import net.minecraft.util.datafix.fixes.EntityZombieVillagerTypeFix;
import net.minecraft.util.datafix.fixes.EntityZombifiedPiglinRenameFix;
import net.minecraft.util.datafix.fixes.EquippableAssetRenameFix;
import net.minecraft.util.datafix.fixes.FeatureFlagRemoveFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.FireResistantToDamageResistantComponentFix;
import net.minecraft.util.datafix.fixes.FixProjectileStoredItem;
import net.minecraft.util.datafix.fixes.FoodToConsumableFix;
import net.minecraft.util.datafix.fixes.ForcePoiRebuild;
import net.minecraft.util.datafix.fixes.FurnaceRecipeFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.GossipUUIDFix;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.HorseBodyArmorItemFix;
import net.minecraft.util.datafix.fixes.IglooMetadataRemovalFix;
import net.minecraft.util.datafix.fixes.InvalidBlockEntityLockFix;
import net.minecraft.util.datafix.fixes.InvalidLockComponentFix;
import net.minecraft.util.datafix.fixes.ItemBannerColorFix;
import net.minecraft.util.datafix.fixes.ItemCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemLoreFix;
import net.minecraft.util.datafix.fixes.ItemPotionFix;
import net.minecraft.util.datafix.fixes.ItemRemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.ItemShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.ItemStackCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentNamesFix;
import net.minecraft.util.datafix.fixes.ItemStackMapIdFix;
import net.minecraft.util.datafix.fixes.ItemStackSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.ItemStackUUIDFix;
import net.minecraft.util.datafix.fixes.ItemWaterPotionFix;
import net.minecraft.util.datafix.fixes.ItemWrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.fixes.JigsawPropertiesFix;
import net.minecraft.util.datafix.fixes.JigsawRotationFix;
import net.minecraft.util.datafix.fixes.JukeboxTicksSinceSongStartedFix;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LegacyDragonFightFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelFlatGeneratorInfoFix;
import net.minecraft.util.datafix.fixes.LevelLegacyWorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.LevelUUIDFix;
import net.minecraft.util.datafix.fixes.LockComponentPredicateFix;
import net.minecraft.util.datafix.fixes.LodestoneCompassComponentFix;
import net.minecraft.util.datafix.fixes.MapBannerBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiryDataFix;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.MobEffectIdFix;
import net.minecraft.util.datafix.fixes.MobSpawnerEntityIdentifiersFix;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveDisplayNameFix;
import net.minecraft.util.datafix.fixes.ObjectiveRenderTypeFix;
import net.minecraft.util.datafix.fixes.OminousBannerBlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRarityFix;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsForceVBOFix;
import net.minecraft.util.datafix.fixes.OptionsKeyLwjgl3Fix;
import net.minecraft.util.datafix.fixes.OptionsKeyTranslationFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguageFix;
import net.minecraft.util.datafix.fixes.OptionsMenuBlurrinessFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OptionsRenameFieldFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.ParticleUnflatteningFix;
import net.minecraft.util.datafix.fixes.PlayerHeadBlockProfileFix;
import net.minecraft.util.datafix.fixes.PlayerUUIDFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.PrimedTntBlockStateFixer;
import net.minecraft.util.datafix.fixes.ProjectileStoredWeaponFix;
import net.minecraft.util.datafix.fixes.RandomSequenceSettingsFix;
import net.minecraft.util.datafix.fixes.RecipesFix;
import net.minecraft.util.datafix.fixes.RecipesRenameningFix;
import net.minecraft.util.datafix.fixes.RedstoneWireConnectionsFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.RemapChunkStatusFix;
import net.minecraft.util.datafix.fixes.RemoveEmptyItemInBrushableBlockFix;
import net.minecraft.util.datafix.fixes.RemoveGolemGossipFix;
import net.minecraft.util.datafix.fixes.RenameEnchantmentsFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFansFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFix;
import net.minecraft.util.datafix.fixes.ReorganizePoi;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SavedDataUUIDFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplaySlotFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsCounterFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StriderGravityFix;
import net.minecraft.util.datafix.fixes.StructureReferenceCountFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TeamDisplayNameFix;
import net.minecraft.util.datafix.fixes.TippedArrowPotionToItemFix;
import net.minecraft.util.datafix.fixes.TrappedChestBlockEntityFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.VillagerDataFix;
import net.minecraft.util.datafix.fixes.VillagerFollowRangeFix;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerSetCanPickUpLootFix;
import net.minecraft.util.datafix.fixes.VillagerTradeFix;
import net.minecraft.util.datafix.fixes.WallPropertyFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WriteAndReadFix;
import net.minecraft.util.datafix.fixes.ZombieVillagerRebuildXpFix;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V100;
import net.minecraft.util.datafix.schemas.V102;
import net.minecraft.util.datafix.schemas.V1022;
import net.minecraft.util.datafix.schemas.V106;
import net.minecraft.util.datafix.schemas.V107;
import net.minecraft.util.datafix.schemas.V1125;
import net.minecraft.util.datafix.schemas.V135;
import net.minecraft.util.datafix.schemas.V143;
import net.minecraft.util.datafix.schemas.V1451;
import net.minecraft.util.datafix.schemas.V1451_1;
import net.minecraft.util.datafix.schemas.V1451_2;
import net.minecraft.util.datafix.schemas.V1451_3;
import net.minecraft.util.datafix.schemas.V1451_4;
import net.minecraft.util.datafix.schemas.V1451_5;
import net.minecraft.util.datafix.schemas.V1451_6;
import net.minecraft.util.datafix.schemas.V1460;
import net.minecraft.util.datafix.schemas.V1466;
import net.minecraft.util.datafix.schemas.V1470;
import net.minecraft.util.datafix.schemas.V1481;
import net.minecraft.util.datafix.schemas.V1483;
import net.minecraft.util.datafix.schemas.V1486;
import net.minecraft.util.datafix.schemas.V1510;
import net.minecraft.util.datafix.schemas.V1800;
import net.minecraft.util.datafix.schemas.V1801;
import net.minecraft.util.datafix.schemas.V1904;
import net.minecraft.util.datafix.schemas.V1906;
import net.minecraft.util.datafix.schemas.V1909;
import net.minecraft.util.datafix.schemas.V1920;
import net.minecraft.util.datafix.schemas.V1928;
import net.minecraft.util.datafix.schemas.V1929;
import net.minecraft.util.datafix.schemas.V1931;
import net.minecraft.util.datafix.schemas.V2100;
import net.minecraft.util.datafix.schemas.V2501;
import net.minecraft.util.datafix.schemas.V2502;
import net.minecraft.util.datafix.schemas.V2505;
import net.minecraft.util.datafix.schemas.V2509;
import net.minecraft.util.datafix.schemas.V2519;
import net.minecraft.util.datafix.schemas.V2522;
import net.minecraft.util.datafix.schemas.V2551;
import net.minecraft.util.datafix.schemas.V2568;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;
import net.minecraft.util.datafix.schemas.V3438;
import net.minecraft.util.datafix.schemas.V3448;
import net.minecraft.util.datafix.schemas.V3682;
import net.minecraft.util.datafix.schemas.V3683;
import net.minecraft.util.datafix.schemas.V3685;
import net.minecraft.util.datafix.schemas.V3689;
import net.minecraft.util.datafix.schemas.V3799;
import net.minecraft.util.datafix.schemas.V3807;
import net.minecraft.util.datafix.schemas.V3808;
import net.minecraft.util.datafix.schemas.V3808_1;
import net.minecraft.util.datafix.schemas.V3808_2;
import net.minecraft.util.datafix.schemas.V3816;
import net.minecraft.util.datafix.schemas.V3818;
import net.minecraft.util.datafix.schemas.V3818_3;
import net.minecraft.util.datafix.schemas.V3818_4;
import net.minecraft.util.datafix.schemas.V3818_5;
import net.minecraft.util.datafix.schemas.V3825;
import net.minecraft.util.datafix.schemas.V3938;
import net.minecraft.util.datafix.schemas.V4059;
import net.minecraft.util.datafix.schemas.V4067;
import net.minecraft.util.datafix.schemas.V4070;
import net.minecraft.util.datafix.schemas.V4071;
import net.minecraft.util.datafix.schemas.V501;
import net.minecraft.util.datafix.schemas.V700;
import net.minecraft.util.datafix.schemas.V701;
import net.minecraft.util.datafix.schemas.V702;
import net.minecraft.util.datafix.schemas.V703;
import net.minecraft.util.datafix.schemas.V704;
import net.minecraft.util.datafix.schemas.V705;
import net.minecraft.util.datafix.schemas.V808;
import net.minecraft.util.datafix.schemas.V99;

public class DataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
    private static final DataFixerBuilder.Result DATA_FIXER = DataFixers.createFixerUpper();
    public static final int BLENDING_VERSION = 4185;

    private DataFixers() {
    }

    public static DataFixer getDataFixer() {
        return DATA_FIXER.fixer();
    }

    private static DataFixerBuilder.Result createFixerUpper() {
        DataFixerBuilder $$0 = new DataFixerBuilder(SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        DataFixers.addFixers($$0);
        return $$0.build();
    }

    public static CompletableFuture<?> optimize(Set<DSL.TypeReference> $$0) {
        if ($$0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService $$1 = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return DATA_FIXER.optimize($$0, (Executor)$$1);
    }

    private static void addFixers(DataFixerBuilder $$02) {
        $$02.addSchema(99, V99::new);
        Schema $$12 = $$02.addSchema(100, V100::new);
        $$02.addFixer((DataFix)new EntityEquipmentToArmorAndHandFix($$12, true));
        Schema $$2 = $$02.addSchema(101, SAME);
        $$02.addFixer((DataFix)new BlockEntitySignTextStrictJsonFix($$2, false));
        $$02.addFixer((DataFix)new VillagerSetCanPickUpLootFix($$2));
        Schema $$3 = $$02.addSchema(102, V102::new);
        $$02.addFixer((DataFix)new ItemIdFix($$3, true));
        $$02.addFixer((DataFix)new ItemPotionFix($$3, false));
        Schema $$4 = $$02.addSchema(105, SAME);
        $$02.addFixer((DataFix)new ItemSpawnEggFix($$4, true));
        Schema $$5 = $$02.addSchema(106, V106::new);
        $$02.addFixer((DataFix)new MobSpawnerEntityIdentifiersFix($$5, true));
        Schema $$6 = $$02.addSchema(107, V107::new);
        $$02.addFixer((DataFix)new EntityMinecartIdentifiersFix($$6));
        Schema $$7 = $$02.addSchema(108, SAME);
        $$02.addFixer((DataFix)new EntityStringUuidFix($$7, true));
        Schema $$8 = $$02.addSchema(109, SAME);
        $$02.addFixer((DataFix)new EntityHealthFix($$8, true));
        Schema $$9 = $$02.addSchema(110, SAME);
        $$02.addFixer((DataFix)new EntityHorseSaddleFix($$9, true));
        Schema $$10 = $$02.addSchema(111, SAME);
        $$02.addFixer((DataFix)new EntityPaintingItemFrameDirectionFix($$10, true));
        Schema $$11 = $$02.addSchema(113, SAME);
        $$02.addFixer((DataFix)new EntityRedundantChanceTagsFix($$11, true));
        Schema $$122 = $$02.addSchema(135, V135::new);
        $$02.addFixer((DataFix)new EntityRidingToPassengersFix($$122, true));
        Schema $$13 = $$02.addSchema(143, V143::new);
        $$02.addFixer((DataFix)new EntityTippedArrowFix($$13, true));
        Schema $$14 = $$02.addSchema(147, SAME);
        $$02.addFixer((DataFix)new EntityArmorStandSilentFix($$14, true));
        Schema $$15 = $$02.addSchema(165, SAME);
        $$02.addFixer((DataFix)new ItemWrittenBookPagesStrictJsonFix($$15, true));
        Schema $$16 = $$02.addSchema(501, V501::new);
        $$02.addFixer((DataFix)new AddNewChoices($$16, "Add 1.10 entities fix", References.ENTITY));
        Schema $$17 = $$02.addSchema(502, SAME);
        $$02.addFixer(ItemRenameFix.create($$17, "cooked_fished item renamer", $$0 -> Objects.equals(NamespacedSchema.ensureNamespaced($$0), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : $$0));
        $$02.addFixer((DataFix)new EntityZombieVillagerTypeFix($$17, false));
        Schema $$18 = $$02.addSchema(505, SAME);
        $$02.addFixer((DataFix)new OptionsForceVBOFix($$18, false));
        Schema $$19 = $$02.addSchema(700, V700::new);
        $$02.addFixer((DataFix)new EntityElderGuardianSplitFix($$19, true));
        Schema $$20 = $$02.addSchema(701, V701::new);
        $$02.addFixer((DataFix)new EntitySkeletonSplitFix($$20, true));
        Schema $$21 = $$02.addSchema(702, V702::new);
        $$02.addFixer((DataFix)new EntityZombieSplitFix($$21));
        Schema $$22 = $$02.addSchema(703, V703::new);
        $$02.addFixer((DataFix)new EntityHorseSplitFix($$22, true));
        Schema $$23 = $$02.addSchema(704, V704::new);
        $$02.addFixer((DataFix)new BlockEntityIdFix($$23, true));
        Schema $$24 = $$02.addSchema(705, V705::new);
        $$02.addFixer((DataFix)new EntityIdFix($$24, true));
        Schema $$25 = $$02.addSchema(804, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemBannerColorFix($$25, true));
        Schema $$26 = $$02.addSchema(806, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemWaterPotionFix($$26, false));
        Schema $$27 = $$02.addSchema(808, V808::new);
        $$02.addFixer((DataFix)new AddNewChoices($$27, "added shulker box", References.BLOCK_ENTITY));
        Schema $$28 = $$02.addSchema(808, 1, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityShulkerColorFix($$28, false));
        Schema $$29 = $$02.addSchema(813, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemShulkerBoxColorFix($$29, false));
        $$02.addFixer((DataFix)new BlockEntityShulkerBoxColorFix($$29, false));
        Schema $$30 = $$02.addSchema(816, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsLowerCaseLanguageFix($$30, false));
        Schema $$31 = $$02.addSchema(820, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$31, "totem item renamer", DataFixers.createRenamer("minecraft:totem", "minecraft:totem_of_undying")));
        Schema $$32 = $$02.addSchema(1022, V1022::new);
        $$02.addFixer((DataFix)new WriteAndReadFix($$32, "added shoulder entities to players", References.PLAYER));
        Schema $$33 = $$02.addSchema(1125, V1125::new);
        $$02.addFixer((DataFix)new ChunkBedBlockEntityInjecterFix($$33, true));
        $$02.addFixer((DataFix)new BedItemColorFix($$33, false));
        Schema $$34 = $$02.addSchema(1344, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsKeyLwjgl3Fix($$34, false));
        Schema $$35 = $$02.addSchema(1446, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsKeyTranslationFix($$35, false));
        Schema $$36 = $$02.addSchema(1450, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlockStateStructureTemplateFix($$36, false));
        Schema $$37 = $$02.addSchema(1451, V1451::new);
        $$02.addFixer((DataFix)new AddNewChoices($$37, "AddTrappedChestFix", References.BLOCK_ENTITY));
        Schema $$38 = $$02.addSchema(1451, 1, V1451_1::new);
        $$02.addFixer((DataFix)new ChunkPalettedStorageFix($$38, true));
        Schema $$39 = $$02.addSchema(1451, 2, V1451_2::new);
        $$02.addFixer((DataFix)new BlockEntityBlockStateFix($$39, true));
        Schema $$40 = $$02.addSchema(1451, 3, V1451_3::new);
        $$02.addFixer((DataFix)new EntityBlockStateFix($$40, true));
        $$02.addFixer((DataFix)new ItemStackMapIdFix($$40, false));
        Schema $$41 = $$02.addSchema(1451, 4, V1451_4::new);
        $$02.addFixer((DataFix)new BlockNameFlatteningFix($$41, true));
        $$02.addFixer((DataFix)new ItemStackTheFlatteningFix($$41, false));
        Schema $$42 = $$02.addSchema(1451, 5, V1451_5::new);
        $$02.addFixer((DataFix)new ItemRemoveBlockEntityTagFix($$42, false, Set.of("minecraft:noteblock", "minecraft:flower_pot", "minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cactus", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:oak_sapling", "minecraft:spruce_sapling", "minecraft:birch_sapling", "minecraft:jungle_sapling", "minecraft:acacia_sapling", "minecraft:dark_oak_sapling", "minecraft:dead_bush", "minecraft:fern")));
        $$02.addFixer((DataFix)new AddNewChoices($$42, "RemoveNoteBlockFlowerPotFix", References.BLOCK_ENTITY));
        $$02.addFixer((DataFix)new ItemStackSpawnEggFix($$42, false, "minecraft:spawn_egg"));
        $$02.addFixer((DataFix)new EntityWolfColorFix($$42, false));
        $$02.addFixer((DataFix)new BlockEntityBannerColorFix($$42, false));
        $$02.addFixer((DataFix)new LevelFlatGeneratorInfoFix($$42, false));
        Schema $$43 = $$02.addSchema(1451, 6, V1451_6::new);
        $$02.addFixer((DataFix)new StatsCounterFix($$43, true));
        $$02.addFixer((DataFix)new BlockEntityJukeboxFix($$43, false));
        Schema $$44 = $$02.addSchema(1451, 7, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new VillagerTradeFix($$44));
        Schema $$45 = $$02.addSchema(1456, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityItemFrameDirectionFix($$45, false));
        Schema $$46 = $$02.addSchema(1458, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityCustomNameToComponentFix($$46, false));
        $$02.addFixer((DataFix)new ItemCustomNameToComponentFix($$46, false));
        $$02.addFixer((DataFix)new BlockEntityCustomNameToComponentFix($$46, false));
        Schema $$47 = $$02.addSchema(1460, V1460::new);
        $$02.addFixer((DataFix)new EntityPaintingMotiveFix($$47, false));
        Schema $$48 = $$02.addSchema(1466, V1466::new);
        $$02.addFixer((DataFix)new AddNewChoices($$48, "Add DUMMY block entity", References.BLOCK_ENTITY));
        $$02.addFixer((DataFix)new ChunkToProtochunkFix($$48, true));
        Schema $$49 = $$02.addSchema(1470, V1470::new);
        $$02.addFixer((DataFix)new AddNewChoices($$49, "Add 1.13 entities fix", References.ENTITY));
        Schema $$50 = $$02.addSchema(1474, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ColorlessShulkerEntityFix($$50, false));
        $$02.addFixer(BlockRenameFix.create($$50, "Colorless shulker block fixer", $$0 -> Objects.equals(NamespacedSchema.ensureNamespaced($$0), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : $$0));
        $$02.addFixer(ItemRenameFix.create($$50, "Colorless shulker item fixer", $$0 -> Objects.equals(NamespacedSchema.ensureNamespaced($$0), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : $$0));
        Schema $$51 = $$02.addSchema(1475, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$51, "Flowing fixer", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema $$52 = $$02.addSchema(1480, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$52, "Rename coral blocks", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        $$02.addFixer(ItemRenameFix.create($$52, "Rename coral items", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        Schema $$53 = $$02.addSchema(1481, V1481::new);
        $$02.addFixer((DataFix)new AddNewChoices($$53, "Add conduit", References.BLOCK_ENTITY));
        Schema $$54 = $$02.addSchema(1483, V1483::new);
        $$02.addFixer((DataFix)new EntityPufferfishRenameFix($$54, true));
        $$02.addFixer(ItemRenameFix.create($$54, "Rename pufferfish egg item", DataFixers.createRenamer(EntityPufferfishRenameFix.RENAMED_IDS)));
        Schema $$55 = $$02.addSchema(1484, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$55, "Rename seagrass items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        $$02.addFixer(BlockRenameFix.create($$55, "Rename seagrass blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        $$02.addFixer((DataFix)new HeightmapRenamingFix($$55, false));
        Schema $$56 = $$02.addSchema(1486, V1486::new);
        $$02.addFixer((DataFix)new EntityCodSalmonFix($$56, true));
        $$02.addFixer(ItemRenameFix.create($$56, "Rename cod/salmon egg items", DataFixers.createRenamer(EntityCodSalmonFix.RENAMED_EGG_IDS)));
        Schema $$57 = $$02.addSchema(1487, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$57, "Rename prismarine_brick(s)_* blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        $$02.addFixer(BlockRenameFix.create($$57, "Rename prismarine_brick(s)_* items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema $$58 = $$02.addSchema(1488, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$58, "Rename kelp/kelptop", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        $$02.addFixer(ItemRenameFix.create($$58, "Rename kelptop", DataFixers.createRenamer("minecraft:kelp_top", "minecraft:kelp")));
        $$02.addFixer((DataFix)new NamedEntityFix($$58, false, "Command block block entity custom name fix", References.BLOCK_ENTITY, "minecraft:command_block"){

            @Override
            protected Typed<?> fix(Typed<?> $$0) {
                return $$0.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
            }
        });
        $$02.addFixer((DataFix)new NamedEntityFix($$58, false, "Command block minecart custom name fix", References.ENTITY, "minecraft:commandblock_minecart"){

            @Override
            protected Typed<?> fix(Typed<?> $$0) {
                return $$0.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
            }
        });
        $$02.addFixer((DataFix)new IglooMetadataRemovalFix($$58, false));
        Schema $$59 = $$02.addSchema(1490, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$59, "Rename melon_block", DataFixers.createRenamer("minecraft:melon_block", "minecraft:melon")));
        $$02.addFixer(ItemRenameFix.create($$59, "Rename melon_block/melon/speckled_melon", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema $$60 = $$02.addSchema(1492, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkStructuresTemplateRenameFix($$60, false));
        Schema $$61 = $$02.addSchema(1494, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemStackEnchantmentNamesFix($$61, false));
        Schema $$62 = $$02.addSchema(1496, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new LeavesFix($$62, false));
        Schema $$63 = $$02.addSchema(1500, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlockEntityKeepPacked($$63, false));
        Schema $$64 = $$02.addSchema(1501, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AdvancementsFix($$64, false));
        Schema $$65 = $$02.addSchema(1502, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$65, "Recipes fix", References.RECIPE, DataFixers.createRenamer(RecipesFix.RECIPES)));
        Schema $$66 = $$02.addSchema(1506, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new LevelDataGeneratorOptionsFix($$66, false));
        Schema $$67 = $$02.addSchema(1510, V1510::new);
        $$02.addFixer(BlockRenameFix.create($$67, "Block renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_BLOCKS)));
        $$02.addFixer(ItemRenameFix.create($$67, "Item renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_ITEMS)));
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$67, "Recipes renamening fix", References.RECIPE, DataFixers.createRenamer(RecipesRenameningFix.RECIPES)));
        $$02.addFixer((DataFix)new EntityTheRenameningFix($$67, true));
        $$02.addFixer((DataFix)new StatsRenameFix($$67, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema $$68 = $$02.addSchema(1514, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ObjectiveDisplayNameFix($$68, false));
        $$02.addFixer((DataFix)new TeamDisplayNameFix($$68, false));
        $$02.addFixer((DataFix)new ObjectiveRenderTypeFix($$68, false));
        Schema $$69 = $$02.addSchema(1515, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$69, "Rename coral fan blocks", DataFixers.createRenamer(RenamedCoralFansFix.RENAMED_IDS)));
        Schema $$70 = $$02.addSchema(1624, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new TrappedChestBlockEntityFix($$70, false));
        Schema $$71 = $$02.addSchema(1800, V1800::new);
        $$02.addFixer((DataFix)new AddNewChoices($$71, "Added 1.14 mobs fix", References.ENTITY));
        $$02.addFixer(ItemRenameFix.create($$71, "Rename dye items", DataFixers.createRenamer(DyeItemRenameFix.RENAMED_IDS)));
        Schema $$72 = $$02.addSchema(1801, V1801::new);
        $$02.addFixer((DataFix)new AddNewChoices($$72, "Added Illager Beast", References.ENTITY));
        Schema $$73 = $$02.addSchema(1802, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$73, "Rename sign blocks & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        $$02.addFixer(ItemRenameFix.create($$73, "Rename sign item & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema $$74 = $$02.addSchema(1803, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemLoreFix($$74, false));
        Schema $$75 = $$02.addSchema(1904, V1904::new);
        $$02.addFixer((DataFix)new AddNewChoices($$75, "Added Cats", References.ENTITY));
        $$02.addFixer((DataFix)new EntityCatSplitFix($$75, false));
        Schema $$76 = $$02.addSchema(1905, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkStatusFix($$76, false));
        Schema $$77 = $$02.addSchema(1906, V1906::new);
        $$02.addFixer((DataFix)new AddNewChoices($$77, "Add POI Blocks", References.BLOCK_ENTITY));
        Schema $$78 = $$02.addSchema(1909, V1909::new);
        $$02.addFixer((DataFix)new AddNewChoices($$78, "Add jigsaw", References.BLOCK_ENTITY));
        Schema $$79 = $$02.addSchema(1911, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkStatusFix2($$79, false));
        Schema $$80 = $$02.addSchema(1914, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new WeaponSmithChestLootTableFix($$80, false));
        Schema $$81 = $$02.addSchema(1917, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new CatTypeFix($$81, false));
        Schema $$82 = $$02.addSchema(1918, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new VillagerDataFix($$82, "minecraft:villager"));
        $$02.addFixer((DataFix)new VillagerDataFix($$82, "minecraft:zombie_villager"));
        Schema $$83 = $$02.addSchema(1920, V1920::new);
        $$02.addFixer((DataFix)new NewVillageFix($$83, false));
        $$02.addFixer((DataFix)new AddNewChoices($$83, "Add campfire", References.BLOCK_ENTITY));
        Schema $$84 = $$02.addSchema(1925, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new MapIdFix($$84, false));
        Schema $$85 = $$02.addSchema(1928, V1928::new);
        $$02.addFixer((DataFix)new EntityRavagerRenameFix($$85, true));
        $$02.addFixer(ItemRenameFix.create($$85, "Rename ravager egg item", DataFixers.createRenamer(EntityRavagerRenameFix.RENAMED_IDS)));
        Schema $$86 = $$02.addSchema(1929, V1929::new);
        $$02.addFixer((DataFix)new AddNewChoices($$86, "Add Wandering Trader and Trader Llama", References.ENTITY));
        Schema $$87 = $$02.addSchema(1931, V1931::new);
        $$02.addFixer((DataFix)new AddNewChoices($$87, "Added Fox", References.ENTITY));
        Schema $$88 = $$02.addSchema(1936, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsAddTextBackgroundFix($$88, false));
        Schema $$89 = $$02.addSchema(1946, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ReorganizePoi($$89, false));
        Schema $$90 = $$02.addSchema(1948, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OminousBannerRenameFix($$90));
        Schema $$91 = $$02.addSchema(1953, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OminousBannerBlockEntityRenameFix($$91, false));
        Schema $$92 = $$02.addSchema(1955, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new VillagerRebuildLevelAndXpFix($$92, false));
        $$02.addFixer((DataFix)new ZombieVillagerRebuildXpFix($$92, false));
        Schema $$93 = $$02.addSchema(1961, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkLightRemoveFix($$93, false));
        Schema $$94 = $$02.addSchema(1963, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RemoveGolemGossipFix($$94, false));
        Schema $$95 = $$02.addSchema(2100, V2100::new);
        $$02.addFixer((DataFix)new AddNewChoices($$95, "Added Bee and Bee Stinger", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$95, "Add beehive", References.BLOCK_ENTITY));
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$95, "Rename sugar recipe", References.RECIPE, DataFixers.createRenamer("minecraft:sugar", "minecraft:sugar_from_sugar_cane")));
        $$02.addFixer((DataFix)new AdvancementsRenameFix($$95, false, "Rename sugar recipe advancement", DataFixers.createRenamer("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema $$96 = $$02.addSchema(2202, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkBiomeFix($$96, false));
        Schema $$97 = $$02.addSchema(2209, SAME_NAMESPACED);
        UnaryOperator<String> $$98 = DataFixers.createRenamer("minecraft:bee_hive", "minecraft:beehive");
        $$02.addFixer(ItemRenameFix.create($$97, "Rename bee_hive item to beehive", $$98));
        $$02.addFixer((DataFix)new PoiTypeRenameFix($$97, "Rename bee_hive poi to beehive", $$98));
        $$02.addFixer(BlockRenameFix.create($$97, "Rename bee_hive block to beehive", $$98));
        Schema $$99 = $$02.addSchema(2211, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new StructureReferenceCountFix($$99, false));
        Schema $$100 = $$02.addSchema(2218, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ForcePoiRebuild($$100, false));
        Schema $$101 = $$02.addSchema(2501, V2501::new);
        $$02.addFixer((DataFix)new FurnaceRecipeFix($$101, true));
        Schema $$102 = $$02.addSchema(2502, V2502::new);
        $$02.addFixer((DataFix)new AddNewChoices($$102, "Added Hoglin", References.ENTITY));
        Schema $$103 = $$02.addSchema(2503, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new WallPropertyFix($$103, false));
        $$02.addFixer((DataFix)new AdvancementsRenameFix($$103, false, "Composter category change", DataFixers.createRenamer("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema $$104 = $$02.addSchema(2505, V2505::new);
        $$02.addFixer((DataFix)new AddNewChoices($$104, "Added Piglin", References.ENTITY));
        $$02.addFixer((DataFix)new MemoryExpiryDataFix($$104, "minecraft:villager"));
        Schema $$105 = $$02.addSchema(2508, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$105, "Renamed fungi items to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        $$02.addFixer(BlockRenameFix.create($$105, "Renamed fungi blocks to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema $$106 = $$02.addSchema(2509, V2509::new);
        $$02.addFixer((DataFix)new EntityZombifiedPiglinRenameFix($$106));
        $$02.addFixer(ItemRenameFix.create($$106, "Rename zombie pigman egg item", DataFixers.createRenamer(EntityZombifiedPiglinRenameFix.RENAMED_IDS)));
        Schema $$107 = $$02.addSchema(2511, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityProjectileOwnerFix($$107));
        Schema $$108 = $$02.addSchema(2514, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityUUIDFix($$108));
        $$02.addFixer((DataFix)new BlockEntityUUIDFix($$108));
        $$02.addFixer((DataFix)new PlayerUUIDFix($$108));
        $$02.addFixer((DataFix)new LevelUUIDFix($$108));
        $$02.addFixer((DataFix)new SavedDataUUIDFix($$108));
        $$02.addFixer((DataFix)new ItemStackUUIDFix($$108));
        Schema $$109 = $$02.addSchema(2516, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new GossipUUIDFix($$109, "minecraft:villager"));
        $$02.addFixer((DataFix)new GossipUUIDFix($$109, "minecraft:zombie_villager"));
        Schema $$110 = $$02.addSchema(2518, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new JigsawPropertiesFix($$110, false));
        $$02.addFixer((DataFix)new JigsawRotationFix($$110, false));
        Schema $$111 = $$02.addSchema(2519, V2519::new);
        $$02.addFixer((DataFix)new AddNewChoices($$111, "Added Strider", References.ENTITY));
        Schema $$112 = $$02.addSchema(2522, V2522::new);
        $$02.addFixer((DataFix)new AddNewChoices($$112, "Added Zoglin", References.ENTITY));
        Schema $$113 = $$02.addSchema(2523, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AttributesRenameLegacy($$113, "Attribute renames", DataFixers.createRenamerNoNamespace((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"minecraft:generic.max_health").put((Object)"Max Health", (Object)"minecraft:generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"minecraft:horse.jump_strength").put((Object)"Jump Strength", (Object)"minecraft:horse.jump_strength").put((Object)"generic.followRange", (Object)"minecraft:generic.follow_range").put((Object)"Follow Range", (Object)"minecraft:generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"minecraft:generic.movement_speed").put((Object)"Movement Speed", (Object)"minecraft:generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"minecraft:generic.flying_speed").put((Object)"Flying Speed", (Object)"minecraft:generic.flying_speed").put((Object)"generic.attackDamage", (Object)"minecraft:generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"minecraft:generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"minecraft:generic.attack_speed").put((Object)"generic.armorToughness", (Object)"minecraft:generic.armor_toughness").build())));
        Schema $$114 = $$02.addSchema(2527, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BitStorageAlignFix($$114));
        Schema $$115 = $$02.addSchema(2528, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$115, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        $$02.addFixer(BlockRenameFix.create($$115, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema $$116 = $$02.addSchema(2529, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new StriderGravityFix($$116, false));
        Schema $$117 = $$02.addSchema(2531, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RedstoneWireConnectionsFix($$117));
        Schema $$118 = $$02.addSchema(2533, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new VillagerFollowRangeFix($$118));
        Schema $$119 = $$02.addSchema(2535, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityShulkerRotationFix($$119));
        Schema $$120 = $$02.addSchema(2538, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new LevelLegacyWorldGenSettingsFix($$120));
        Schema $$121 = $$02.addSchema(2550, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new WorldGenSettingsFix($$121));
        Schema $$1222 = $$02.addSchema(2551, V2551::new);
        $$02.addFixer((DataFix)new WriteAndReadFix($$1222, "add types to WorldGenData", References.WORLD_GEN_SETTINGS));
        Schema $$123 = $$02.addSchema(2552, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$123, "Nether biome rename", References.BIOME, DataFixers.createRenamer("minecraft:nether", "minecraft:nether_wastes")));
        Schema $$124 = $$02.addSchema(2553, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$124, "Biomes fix", References.BIOME, DataFixers.createRenamer(BiomeFix.BIOMES)));
        Schema $$125 = $$02.addSchema(2558, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new MissingDimensionFix($$125, false));
        $$02.addFixer((DataFix)new OptionsRenameFieldFix($$125, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema $$126 = $$02.addSchema(2568, V2568::new);
        $$02.addFixer((DataFix)new AddNewChoices($$126, "Added Piglin Brute", References.ENTITY));
        Schema $$127 = $$02.addSchema(2571, V2571::new);
        $$02.addFixer((DataFix)new AddNewChoices($$127, "Added Goat", References.ENTITY));
        Schema $$128 = $$02.addSchema(2679, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new CauldronRenameFix($$128, false));
        Schema $$129 = $$02.addSchema(2680, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$129, "Renamed grass path item to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        $$02.addFixer(BlockRenameFix.create($$129, "Renamed grass path block to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        Schema $$130 = $$02.addSchema(2684, V2684::new);
        $$02.addFixer((DataFix)new AddNewChoices($$130, "Added Sculk Sensor", References.BLOCK_ENTITY));
        Schema $$131 = $$02.addSchema(2686, V2686::new);
        $$02.addFixer((DataFix)new AddNewChoices($$131, "Added Axolotl", References.ENTITY));
        Schema $$132 = $$02.addSchema(2688, V2688::new);
        $$02.addFixer((DataFix)new AddNewChoices($$132, "Added Glow Squid", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$132, "Added Glow Item Frame", References.ENTITY));
        Schema $$133 = $$02.addSchema(2690, SAME_NAMESPACED);
        ImmutableMap $$134 = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        $$02.addFixer(ItemRenameFix.create($$133, "Renamed copper block items to new oxidized terms", DataFixers.createRenamer((Map<String, String>)$$134)));
        $$02.addFixer(BlockRenameFix.create($$133, "Renamed copper blocks to new oxidized terms", DataFixers.createRenamer((Map<String, String>)$$134)));
        Schema $$135 = $$02.addSchema(2691, SAME_NAMESPACED);
        ImmutableMap $$136 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        $$02.addFixer(ItemRenameFix.create($$135, "Rename copper item suffixes", DataFixers.createRenamer((Map<String, String>)$$136)));
        $$02.addFixer(BlockRenameFix.create($$135, "Rename copper blocks suffixes", DataFixers.createRenamer((Map<String, String>)$$136)));
        Schema $$137 = $$02.addSchema(2693, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AddFlagIfNotPresentFix($$137, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema $$138 = $$02.addSchema(2696, SAME_NAMESPACED);
        ImmutableMap $$139 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        $$02.addFixer(ItemRenameFix.create($$138, "Renamed grimstone block items to deepslate", DataFixers.createRenamer((Map<String, String>)$$139)));
        $$02.addFixer(BlockRenameFix.create($$138, "Renamed grimstone blocks to deepslate", DataFixers.createRenamer((Map<String, String>)$$139)));
        Schema $$140 = $$02.addSchema(2700, SAME_NAMESPACED);
        $$02.addFixer(BlockRenameFix.create($$140, "Renamed cave vines blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema $$141 = $$02.addSchema(2701, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new SavedDataFeaturePoolElementFix($$141));
        Schema $$142 = $$02.addSchema(2702, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AbstractArrowPickupFix($$142));
        Schema $$143 = $$02.addSchema(2704, V2704::new);
        $$02.addFixer((DataFix)new AddNewChoices($$143, "Added Goat", References.ENTITY));
        Schema $$144 = $$02.addSchema(2707, V2707::new);
        $$02.addFixer((DataFix)new AddNewChoices($$144, "Added Marker", References.ENTITY));
        $$02.addFixer((DataFix)new AddFlagIfNotPresentFix($$144, References.WORLD_GEN_SETTINGS, "has_increased_height_already", true));
        Schema $$145 = $$02.addSchema(2710, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new StatsRenameFix($$145, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema $$146 = $$02.addSchema(2717, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$146, "Rename azalea_leaves_flowers", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        $$02.addFixer(BlockRenameFix.create($$146, "Rename azalea_leaves_flowers items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema $$147 = $$02.addSchema(2825, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AddFlagIfNotPresentFix($$147, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema $$148 = $$02.addSchema(2831, V2831::new);
        $$02.addFixer((DataFix)new SpawnerDataFix($$148));
        Schema $$149 = $$02.addSchema(2832, V2832::new);
        $$02.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix($$149));
        $$02.addFixer((DataFix)new ChunkHeightAndBiomeFix($$149));
        Schema $$150 = $$02.addSchema(2833, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix($$150));
        Schema $$151 = $$02.addSchema(2838, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$151, "Caves and Cliffs biome renames", References.BIOME, DataFixers.createRenamer(CavesAndCliffsRenames.RENAMES)));
        Schema $$152 = $$02.addSchema(2841, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkProtoTickListFix($$152));
        Schema $$153 = $$02.addSchema(2842, V2842::new);
        $$02.addFixer((DataFix)new ChunkRenamesFix($$153));
        Schema $$154 = $$02.addSchema(2843, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OverreachingTickFix($$154));
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$154, "Remove Deep Warm Ocean", References.BIOME, DataFixers.createRenamer("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema $$155 = $$02.addSchema(2846, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AdvancementsRenameFix($$155, false, "Rename some C&C part 2 advancements", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema $$156 = $$02.addSchema(2852, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix($$156));
        Schema $$157 = $$02.addSchema(2967, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new StructureSettingsFlattenFix($$157));
        Schema $$158 = $$02.addSchema(2970, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new StructuresBecomeConfiguredFix($$158));
        Schema $$159 = $$02.addSchema(3076, V3076::new);
        $$02.addFixer((DataFix)new AddNewChoices($$159, "Added Sculk Catalyst", References.BLOCK_ENTITY));
        Schema $$160 = $$02.addSchema(3077, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkDeleteIgnoredLightDataFix($$160));
        Schema $$161 = $$02.addSchema(3078, V3078::new);
        $$02.addFixer((DataFix)new AddNewChoices($$161, "Added Frog", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$161, "Added Tadpole", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$161, "Added Sculk Shrieker", References.BLOCK_ENTITY));
        Schema $$162 = $$02.addSchema(3081, V3081::new);
        $$02.addFixer((DataFix)new AddNewChoices($$162, "Added Warden", References.ENTITY));
        Schema $$163 = $$02.addSchema(3082, V3082::new);
        $$02.addFixer((DataFix)new AddNewChoices($$163, "Added Chest Boat", References.ENTITY));
        Schema $$164 = $$02.addSchema(3083, V3083::new);
        $$02.addFixer((DataFix)new AddNewChoices($$164, "Added Allay", References.ENTITY));
        Schema $$165 = $$02.addSchema(3084, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$165, "game_event_renames_3084", References.GAME_EVENT_NAME, DataFixers.createRenamer((Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build())));
        Schema $$166 = $$02.addSchema(3086, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityVariantFix($$166, "Change cat variant type", References.ENTITY, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)Util.make(new Int2ObjectOpenHashMap(), $$0 -> {
            $$0.defaultReturnValue((Object)"minecraft:tabby");
            $$0.put(0, (Object)"minecraft:tabby");
            $$0.put(1, (Object)"minecraft:black");
            $$0.put(2, (Object)"minecraft:red");
            $$0.put(3, (Object)"minecraft:siamese");
            $$0.put(4, (Object)"minecraft:british");
            $$0.put(5, (Object)"minecraft:calico");
            $$0.put(6, (Object)"minecraft:persian");
            $$0.put(7, (Object)"minecraft:ragdoll");
            $$0.put(8, (Object)"minecraft:white");
            $$0.put(9, (Object)"minecraft:jellie");
            $$0.put(10, (Object)"minecraft:all_black");
        })).get(arg_0)));
        ImmutableMap $$167 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        $$02.addFixer((DataFix)new CriteriaRenameFix($$166, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", $$1 -> (String)$$167.getOrDefault($$1, $$1)));
        Schema $$168 = $$02.addSchema(3087, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityVariantFix($$168, "Change frog variant type", References.ENTITY, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)Util.make(new Int2ObjectOpenHashMap(), $$0 -> {
            $$0.put(0, (Object)"minecraft:temperate");
            $$0.put(1, (Object)"minecraft:warm");
            $$0.put(2, (Object)"minecraft:cold");
        })).get(arg_0)));
        Schema $$169 = $$02.addSchema(3090, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityFieldsRenameFix($$169, "EntityPaintingFieldsRenameFix", "minecraft:painting", Map.of("Motive", "variant", "Facing", "facing")));
        Schema $$170 = $$02.addSchema(3093, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityGoatMissingStateFix($$170));
        Schema $$171 = $$02.addSchema(3094, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new GoatHornIdFix($$171));
        Schema $$172 = $$02.addSchema(3097, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new FilteredBooksFix($$172));
        $$02.addFixer((DataFix)new FilteredSignsFix($$172));
        Map<String, String> $$173 = Map.of("minecraft:british", "minecraft:british_shorthair");
        $$02.addFixer((DataFix)new VariantRenameFix($$172, "Rename british shorthair", References.ENTITY, "minecraft:cat", $$173));
        $$02.addFixer((DataFix)new CriteriaRenameFix($$172, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", $$1 -> $$173.getOrDefault($$1, (String)$$1)));
        $$02.addFixer((DataFix)new PoiTypeRemoveFix($$172, "Remove unpopulated villager PoI types", Set.of("minecraft:unemployed", "minecraft:nitwit")::contains));
        Schema $$174 = $$02.addSchema(3108, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlendingDataRemoveFromNetherEndFix($$174));
        Schema $$175 = $$02.addSchema(3201, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsProgrammerArtFix($$175));
        Schema $$176 = $$02.addSchema(3202, V3202::new);
        $$02.addFixer((DataFix)new AddNewChoices($$176, "Added Hanging Sign", References.BLOCK_ENTITY));
        Schema $$177 = $$02.addSchema(3203, V3203::new);
        $$02.addFixer((DataFix)new AddNewChoices($$177, "Added Camel", References.ENTITY));
        Schema $$178 = $$02.addSchema(3204, V3204::new);
        $$02.addFixer((DataFix)new AddNewChoices($$178, "Added Chiseled Bookshelf", References.BLOCK_ENTITY));
        Schema $$179 = $$02.addSchema(3209, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ItemStackSpawnEggFix($$179, false, "minecraft:pig_spawn_egg"));
        Schema $$180 = $$02.addSchema(3214, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsAmbientOcclusionFix($$180));
        Schema $$181 = $$02.addSchema(3319, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsAccessibilityOnboardFix($$181));
        Schema $$182 = $$02.addSchema(3322, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EffectDurationFix($$182));
        Schema $$183 = $$02.addSchema(3325, V3325::new);
        $$02.addFixer((DataFix)new AddNewChoices($$183, "Added displays", References.ENTITY));
        Schema $$184 = $$02.addSchema(3326, V3326::new);
        $$02.addFixer((DataFix)new AddNewChoices($$184, "Added Sniffer", References.ENTITY));
        Schema $$185 = $$02.addSchema(3327, V3327::new);
        $$02.addFixer((DataFix)new AddNewChoices($$185, "Archaeology", References.BLOCK_ENTITY));
        Schema $$186 = $$02.addSchema(3328, V3328::new);
        $$02.addFixer((DataFix)new AddNewChoices($$186, "Added interaction", References.ENTITY));
        Schema $$187 = $$02.addSchema(3438, V3438::new);
        $$02.addFixer(BlockEntityRenameFix.create($$187, "Rename Suspicious Sand to Brushable Block", DataFixers.createRenamer("minecraft:suspicious_sand", "minecraft:brushable_block")));
        $$02.addFixer((DataFix)new EntityBrushableBlockFieldsRenameFix($$187));
        $$02.addFixer(ItemRenameFix.create($$187, "Pottery shard renaming", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:pottery_shard_archer", (Object)"minecraft:archer_pottery_shard", (Object)"minecraft:pottery_shard_prize", (Object)"minecraft:prize_pottery_shard", (Object)"minecraft:pottery_shard_arms_up", (Object)"minecraft:arms_up_pottery_shard", (Object)"minecraft:pottery_shard_skull", (Object)"minecraft:skull_pottery_shard"))));
        $$02.addFixer((DataFix)new AddNewChoices($$187, "Added calibrated sculk sensor", References.BLOCK_ENTITY));
        Schema $$188 = $$02.addSchema(3439, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix($$188, "Updated sign text format for Signs", "minecraft:sign"));
        $$02.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix($$188, "Updated sign text format for Hanging Signs", "minecraft:hanging_sign"));
        Schema $$189 = $$02.addSchema(3440, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new NamespacedTypeRenameFix($$189, "Replace experimental 1.20 overworld", References.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DataFixers.createRenamer("minecraft:overworld_update_1_20", "minecraft:overworld")));
        $$02.addFixer((DataFix)new FeatureFlagRemoveFix($$189, "Remove 1.20 feature toggle", Set.of("minecraft:update_1_20")));
        Schema $$190 = $$02.addSchema(3447, SAME_NAMESPACED);
        $$02.addFixer(ItemRenameFix.create($$190, "Pottery shard item renaming to Pottery sherd", DataFixers.createRenamer(Stream.of("minecraft:angler_pottery_shard", "minecraft:archer_pottery_shard", "minecraft:arms_up_pottery_shard", "minecraft:blade_pottery_shard", "minecraft:brewer_pottery_shard", "minecraft:burn_pottery_shard", "minecraft:danger_pottery_shard", "minecraft:explorer_pottery_shard", "minecraft:friend_pottery_shard", "minecraft:heart_pottery_shard", "minecraft:heartbreak_pottery_shard", "minecraft:howl_pottery_shard", "minecraft:miner_pottery_shard", "minecraft:mourner_pottery_shard", "minecraft:plenty_pottery_shard", "minecraft:prize_pottery_shard", "minecraft:sheaf_pottery_shard", "minecraft:shelter_pottery_shard", "minecraft:skull_pottery_shard", "minecraft:snort_pottery_shard").collect(Collectors.toMap(Function.identity(), $$0 -> $$0.replace("_pottery_shard", "_pottery_sherd"))))));
        Schema $$191 = $$02.addSchema(3448, V3448::new);
        $$02.addFixer((DataFix)new DecoratedPotFieldRenameFix($$191));
        Schema $$192 = $$02.addSchema(3450, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RemapChunkStatusFix($$192, "Remove liquid_carvers and heightmap chunk statuses", DataFixers.createRenamer(Map.of("minecraft:liquid_carvers", "minecraft:carvers", "minecraft:heightmaps", "minecraft:spawn"))));
        Schema $$193 = $$02.addSchema(3451, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChunkDeleteLightFix($$193));
        Schema $$194 = $$02.addSchema(3459, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new LegacyDragonFightFix($$194));
        Schema $$195 = $$02.addSchema(3564, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new DropInvalidSignDataFix($$195, "Drop invalid sign datafix data", "minecraft:sign"));
        $$02.addFixer((DataFix)new DropInvalidSignDataFix($$195, "Drop invalid hanging sign datafix data", "minecraft:hanging_sign"));
        Schema $$196 = $$02.addSchema(3565, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RandomSequenceSettingsFix($$196));
        Schema $$197 = $$02.addSchema(3566, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ScoreboardDisplaySlotFix($$197));
        Schema $$198 = $$02.addSchema(3568, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new MobEffectIdFix($$198));
        Schema $$199 = $$02.addSchema(3682, V3682::new);
        $$02.addFixer((DataFix)new AddNewChoices($$199, "Added Crafter", References.BLOCK_ENTITY));
        Schema $$200 = $$02.addSchema(3683, V3683::new);
        $$02.addFixer((DataFix)new PrimedTntBlockStateFixer($$200));
        Schema $$201 = $$02.addSchema(3685, V3685::new);
        $$02.addFixer((DataFix)new FixProjectileStoredItem($$201));
        Schema $$202 = $$02.addSchema(3689, V3689::new);
        $$02.addFixer((DataFix)new AddNewChoices($$202, "Added Breeze", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$202, "Added Trial Spawner", References.BLOCK_ENTITY));
        Schema $$203 = $$02.addSchema(3692, SAME_NAMESPACED);
        UnaryOperator<String> $$204 = DataFixers.createRenamer(Map.of("minecraft:grass", "minecraft:short_grass"));
        $$02.addFixer(BlockRenameFix.create($$203, "Rename grass block to short_grass", $$204));
        $$02.addFixer(ItemRenameFix.create($$203, "Rename grass item to short_grass", $$204));
        Schema $$205 = $$02.addSchema(3799, V3799::new);
        $$02.addFixer((DataFix)new AddNewChoices($$205, "Added Armadillo", References.ENTITY));
        Schema $$206 = $$02.addSchema(3800, SAME_NAMESPACED);
        UnaryOperator<String> $$207 = DataFixers.createRenamer(Map.of("minecraft:scute", "minecraft:turtle_scute"));
        $$02.addFixer(ItemRenameFix.create($$206, "Rename scute item to turtle_scute", $$207));
        Schema $$208 = $$02.addSchema(3803, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RenameEnchantmentsFix($$208, "Rename sweeping enchant to sweeping_edge", Map.of("minecraft:sweeping", "minecraft:sweeping_edge")));
        Schema $$209 = $$02.addSchema(3807, V3807::new);
        $$02.addFixer((DataFix)new AddNewChoices($$209, "Added Vault", References.BLOCK_ENTITY));
        Schema $$210 = $$02.addSchema(3807, 1, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new MapBannerBlockPosFormatFix($$210));
        Schema $$211 = $$02.addSchema(3808, V3808::new);
        $$02.addFixer((DataFix)new HorseBodyArmorItemFix($$211, "minecraft:horse", "ArmorItem", true));
        Schema $$212 = $$02.addSchema(3808, 1, V3808_1::new);
        $$02.addFixer((DataFix)new HorseBodyArmorItemFix($$212, "minecraft:llama", "DecorItem", false));
        Schema $$213 = $$02.addSchema(3808, 2, V3808_2::new);
        $$02.addFixer((DataFix)new HorseBodyArmorItemFix($$213, "minecraft:trader_llama", "DecorItem", false));
        Schema $$214 = $$02.addSchema(3809, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new ChestedHorsesInventoryZeroIndexingFix($$214));
        Schema $$215 = $$02.addSchema(3812, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new FixWolfHealth($$215));
        Schema $$216 = $$02.addSchema(3813, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlockPosFormatAndRenamesFix($$216));
        Schema $$217 = $$02.addSchema(3814, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AttributesRenameLegacy($$217, "Rename jump strength attribute", DataFixers.createRenamer("minecraft:horse.jump_strength", "minecraft:generic.jump_strength")));
        Schema $$218 = $$02.addSchema(3816, V3816::new);
        $$02.addFixer((DataFix)new AddNewChoices($$218, "Added Bogged", References.ENTITY));
        Schema $$219 = $$02.addSchema(3818, V3818::new);
        $$02.addFixer((DataFix)new BeehiveFieldRenameFix($$219));
        $$02.addFixer((DataFix)new EmptyItemInHotbarFix($$219));
        Schema $$220 = $$02.addSchema(3818, 1, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BannerPatternFormatFix($$220));
        Schema $$221 = $$02.addSchema(3818, 2, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new TippedArrowPotionToItemFix($$221));
        Schema $$222 = $$02.addSchema(3818, 3, V3818_3::new);
        $$02.addFixer((DataFix)new WriteAndReadFix($$222, "Inject data component types", References.DATA_COMPONENTS));
        Schema $$223 = $$02.addSchema(3818, 4, V3818_4::new);
        $$02.addFixer((DataFix)new ParticleUnflatteningFix($$223));
        Schema $$224 = $$02.addSchema(3818, 5, V3818_5::new);
        $$02.addFixer((DataFix)new ItemStackComponentizationFix($$224));
        Schema $$225 = $$02.addSchema(3818, 6, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AreaEffectCloudPotionFix($$225));
        Schema $$226 = $$02.addSchema(3820, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new PlayerHeadBlockProfileFix($$226));
        $$02.addFixer((DataFix)new LodestoneCompassComponentFix($$226));
        Schema $$227 = $$02.addSchema(3825, V3825::new);
        $$02.addFixer((DataFix)new ItemStackCustomNameToOverrideComponentFix($$227));
        $$02.addFixer((DataFix)new BannerEntityCustomNameToOverrideComponentFix($$227));
        $$02.addFixer((DataFix)new TrialSpawnerConfigFix($$227));
        $$02.addFixer((DataFix)new AddNewChoices($$227, "Added Ominous Item Spawner", References.ENTITY));
        Schema $$228 = $$02.addSchema(3828, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EmptyItemInVillagerTradeFix($$228));
        Schema $$229 = $$02.addSchema(3833, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new RemoveEmptyItemInBrushableBlockFix($$229));
        Schema $$230 = $$02.addSchema(3938, V3938::new);
        $$02.addFixer((DataFix)new ProjectileStoredWeaponFix($$230));
        Schema $$231 = $$02.addSchema(3939, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new FeatureFlagRemoveFix($$231, "Remove 1.21 feature toggle", Set.of("minecraft:update_1_21")));
        Schema $$232 = $$02.addSchema(3943, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OptionsMenuBlurrinessFix($$232));
        Schema $$233 = $$02.addSchema(3945, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AttributeModifierIdFix($$233));
        $$02.addFixer((DataFix)new JukeboxTicksSinceSongStartedFix($$233));
        Schema $$234 = $$02.addSchema(4054, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new OminousBannerRarityFix($$234));
        Schema $$235 = $$02.addSchema(4055, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new AttributeIdPrefixFix($$235));
        Schema $$236 = $$02.addSchema(4057, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new CarvingStepRemoveFix($$236));
        Schema $$237 = $$02.addSchema(4059, V4059::new);
        $$02.addFixer((DataFix)new FoodToConsumableFix($$237));
        Schema $$238 = $$02.addSchema(4061, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new TrialSpawnerConfigInRegistryFix($$238));
        Schema $$239 = $$02.addSchema(4064, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new FireResistantToDamageResistantComponentFix($$239));
        Schema $$240 = $$02.addSchema(4067, V4067::new);
        $$02.addFixer((DataFix)new BoatSplitFix($$240));
        $$02.addFixer((DataFix)new FeatureFlagRemoveFix($$240, "Remove Bundle experimental feature flag", Set.of("minecraft:bundle")));
        Schema $$241 = $$02.addSchema(4068, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new LockComponentPredicateFix($$241));
        $$02.addFixer((DataFix)new ContainerBlockEntityLockPredicateFix($$241));
        Schema $$242 = $$02.addSchema(4070, V4070::new);
        $$02.addFixer((DataFix)new AddNewChoices($$242, "Added Pale Oak Boat and Pale Oak Chest Boat", References.ENTITY));
        Schema $$243 = $$02.addSchema(4071, V4071::new);
        $$02.addFixer((DataFix)new AddNewChoices($$243, "Added Creaking", References.ENTITY));
        $$02.addFixer((DataFix)new AddNewChoices($$243, "Added Creaking Heart", References.BLOCK_ENTITY));
        Schema $$244 = $$02.addSchema(4081, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntitySalmonSizeFix($$244));
        Schema $$245 = $$02.addSchema(4173, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityFieldsRenameFix($$245, "Rename TNT Minecart fuse", "minecraft:tnt_minecart", Map.of("TNTFuse", "fuse")));
        Schema $$246 = $$02.addSchema(4175, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EquippableAssetRenameFix($$246));
        $$02.addFixer((DataFix)new CustomModelDataExpandFix($$246));
        Schema $$247 = $$02.addSchema(4176, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new InvalidBlockEntityLockFix($$247));
        $$02.addFixer((DataFix)new InvalidLockComponentFix($$247));
        Schema $$248 = $$02.addSchema(4180, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new FeatureFlagRemoveFix($$248, "Remove Winter Drop toggle", Set.of("minecraft:winter_drop")));
        Schema $$249 = $$02.addSchema(4181, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix($$249, "minecraft:furnace"));
        $$02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix($$249, "minecraft:smoker"));
        $$02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix($$249, "minecraft:blast_furnace"));
        Schema $$250 = $$02.addSchema(4185, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new BlendingDataFix($$250));
        Schema $$251 = $$02.addSchema(4187, SAME_NAMESPACED);
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Villager follow range fix undo", "minecraft:villager", "minecraft:follow_range", $$0 -> $$0 == 48.0 ? 16.0 : $$0));
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Bee follow range fix", "minecraft:bee", "minecraft:follow_range", $$0 -> $$0 == 48.0 ? 16.0 : $$0));
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Allay follow range fix", "minecraft:allay", "minecraft:follow_range", $$0 -> $$0 == 48.0 ? 16.0 : $$0));
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Llama follow range fix", "minecraft:llama", "minecraft:follow_range", $$0 -> $$0 == 40.0 ? 16.0 : $$0));
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Piglin Brute follow range fix", "minecraft:piglin_brute", "minecraft:follow_range", $$0 -> $$0 == 16.0 ? 12.0 : $$0));
        $$02.addFixer((DataFix)new EntityAttributeBaseValueFix($$251, "Warden follow range fix", "minecraft:warden", "minecraft:follow_range", $$0 -> $$0 == 16.0 ? 24.0 : $$0));
    }

    private static UnaryOperator<String> createRenamerNoNamespace(Map<String, String> $$0) {
        return $$1 -> $$0.getOrDefault($$1, (String)$$1);
    }

    private static UnaryOperator<String> createRenamer(Map<String, String> $$0) {
        return $$1 -> $$0.getOrDefault(NamespacedSchema.ensureNamespaced($$1), (String)$$1);
    }

    private static UnaryOperator<String> createRenamer(String $$0, String $$1) {
        return $$2 -> Objects.equals(NamespacedSchema.ensureNamespaced($$2), $$0) ? $$1 : $$2;
    }
}

