/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class Sheep
extends Animal
implements Shearable {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.defineId(Sheep.class, EntityDataSerializers.BYTE);
    private static final Map<DyeColor, Integer> COLOR_BY_DYE = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap($$0 -> $$0, Sheep::createSheepColor)));
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;

    private static int createSheepColor(DyeColor $$0) {
        if ($$0 == DyeColor.WHITE) {
            return -1644826;
        }
        int $$1 = $$0.getTextureDiffuseColor();
        float $$2 = 0.75f;
        return ARGB.color(255, Mth.floor((float)ARGB.red($$1) * 0.75f), Mth.floor((float)ARGB.green($$1) * 0.75f), Mth.floor((float)ARGB.blue($$1) * 0.75f));
    }

    public static int getColor(DyeColor $$0) {
        return COLOR_BY_DYE.get($$0);
    }

    public Sheep(EntityType<? extends Sheep> $$0, Level $$1) {
        super((EntityType<? extends Animal>)$$0, $$1);
    }

    @Override
    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal(this);
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.25));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(3, new TemptGoal(this, 1.1, $$0 -> $$0.is(ItemTags.SHEEP_FOOD), false));
        this.goalSelector.addGoal(4, new FollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(5, this.eatBlockGoal);
        this.goalSelector.addGoal(6, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
    }

    @Override
    public boolean isFood(ItemStack $$0) {
        return $$0.is(ItemTags.SHEEP_FOOD);
    }

    @Override
    protected void customServerAiStep(ServerLevel $$0) {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep($$0);
    }

    @Override
    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.23f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        super.defineSynchedData($$0);
        $$0.define(DATA_WOOL_ID, (byte)0);
    }

    @Override
    public void handleEntityEvent(byte $$0) {
        if ($$0 == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent($$0);
        }
    }

    public float getHeadEatPositionScale(float $$0) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        if (this.eatAnimationTick < 4) {
            return ((float)this.eatAnimationTick - $$0) / 4.0f;
        }
        return -((float)(this.eatAnimationTick - 40) - $$0) / 4.0f;
    }

    public float getHeadEatAngleScale(float $$0) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float $$1 = ((float)(this.eatAnimationTick - 4) - $$0) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin($$1 * 28.7f);
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.getXRot() * ((float)Math.PI / 180);
    }

    @Override
    public InteractionResult mobInteract(Player $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.getItemInHand($$1);
        if ($$2.is(Items.SHEARS)) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel $$3 = (ServerLevel)level;
                if (this.readyForShearing()) {
                    this.shear($$3, SoundSource.PLAYERS, $$2);
                    this.gameEvent(GameEvent.SHEAR, $$0);
                    $$2.hurtAndBreak(1, $$0, Sheep.getSlotForHand($$1));
                    return InteractionResult.SUCCESS_SERVER;
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract($$0, $$1);
    }

    @Override
    public void shear(ServerLevel $$02, SoundSource $$12, ItemStack $$2) {
        $$02.playSound(null, this, SoundEvents.SHEEP_SHEAR, $$12, 1.0f, 1.0f);
        this.dropFromShearingLootTable($$02, BuiltInLootTables.SHEAR_SHEEP, $$2, ($$0, $$1) -> {
            for (int $$2 = 0; $$2 < $$1.getCount(); ++$$2) {
                ItemEntity $$3 = this.spawnAtLocation((ServerLevel)$$0, $$1.copyWithCount(1), 1.0f);
                if ($$3 == null) continue;
                $$3.setDeltaMovement($$3.getDeltaMovement().add((this.random.nextFloat() - this.random.nextFloat()) * 0.1f, this.random.nextFloat() * 0.05f, (this.random.nextFloat() - this.random.nextFloat()) * 0.1f));
            }
        });
        this.setSheared(true);
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag $$0) {
        super.addAdditionalSaveData($$0);
        $$0.putBoolean("Sheared", this.isSheared());
        $$0.putByte("Color", (byte)this.getColor().getId());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag $$0) {
        super.readAdditionalSaveData($$0);
        this.setSheared($$0.getBoolean("Sheared"));
        this.setColor(DyeColor.byId($$0.getByte("Color")));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHEEP_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource $$0) {
        return SoundEvents.SHEEP_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SHEEP_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos $$0, BlockState $$1) {
        this.playSound(SoundEvents.SHEEP_STEP, 0.15f, 1.0f);
    }

    public DyeColor getColor() {
        return DyeColor.byId(this.entityData.get(DATA_WOOL_ID) & 0xF);
    }

    public void setColor(DyeColor $$0) {
        byte $$1 = this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (byte)($$1 & 0xF0 | $$0.getId() & 0xF));
    }

    public boolean isSheared() {
        return (this.entityData.get(DATA_WOOL_ID) & 0x10) != 0;
    }

    public void setSheared(boolean $$0) {
        byte $$1 = this.entityData.get(DATA_WOOL_ID);
        if ($$0) {
            this.entityData.set(DATA_WOOL_ID, (byte)($$1 | 0x10));
        } else {
            this.entityData.set(DATA_WOOL_ID, (byte)($$1 & 0xFFFFFFEF));
        }
    }

    public static DyeColor getRandomSheepColor(RandomSource $$0) {
        int $$1 = $$0.nextInt(100);
        if ($$1 < 5) {
            return DyeColor.BLACK;
        }
        if ($$1 < 10) {
            return DyeColor.GRAY;
        }
        if ($$1 < 15) {
            return DyeColor.LIGHT_GRAY;
        }
        if ($$1 < 18) {
            return DyeColor.BROWN;
        }
        if ($$0.nextInt(500) == 0) {
            return DyeColor.PINK;
        }
        return DyeColor.WHITE;
    }

    @Override
    @Nullable
    public Sheep getBreedOffspring(ServerLevel $$0, AgeableMob $$1) {
        Sheep $$2 = EntityType.SHEEP.create($$0, EntitySpawnReason.BREEDING);
        if ($$2 != null) {
            DyeColor $$3 = this.getColor();
            DyeColor $$4 = ((Sheep)$$1).getColor();
            $$2.setColor(DyeColor.getMixedColor($$0, $$3, $$4));
        }
        return $$2;
    }

    @Override
    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor $$0, DifficultyInstance $$1, EntitySpawnReason $$2, @Nullable SpawnGroupData $$3) {
        this.setColor(Sheep.getRandomSheepColor($$0.getRandom()));
        return super.finalizeSpawn($$0, $$1, $$2, $$3);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }
}

